/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.health;

import io.camunda.zeebe.broker.SpringBrokerBridge;
import io.camunda.zeebe.broker.system.monitoring.BrokerHealthCheckService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

@Component
public final class BrokerStartupHealthIndicator
implements HealthIndicator {
    private static final Health STARTED = Health.up().build();
    private static final Health NOT_STARTED = Health.down().build();
    private final SpringBrokerBridge brokerBridge;
    private boolean isStarted;

    @Autowired
    public BrokerStartupHealthIndicator(SpringBrokerBridge brokerBridge) {
        this.brokerBridge = brokerBridge;
    }

    public Health health() {
        if (this.isStarted) {
            return STARTED;
        }
        this.isStarted = this.brokerBridge.getBrokerHealthCheckService().map(BrokerHealthCheckService::isBrokerStarted).orElse(false);
        return this.isStarted ? STARTED : NOT_STARTED;
    }
}

