/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.health;

import io.camunda.zeebe.broker.SpringBrokerBridge;
import io.camunda.zeebe.broker.system.monitoring.BrokerHealthCheckService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

@Component
public final class BrokerStatusHealthIndicator
implements HealthIndicator {
    private static final Health HEALTHY = Health.up().build();
    private static final Health UNHEALTHY = Health.down().build();
    private final SpringBrokerBridge brokerBridge;

    @Autowired
    public BrokerStatusHealthIndicator(SpringBrokerBridge brokerBridge) {
        this.brokerBridge = brokerBridge;
    }

    public Health health() {
        Boolean isHealthy = this.brokerBridge.getBrokerHealthCheckService().map(BrokerHealthCheckService::isBrokerHealthy).orElse(false);
        return isHealthy != false ? HEALTHY : UNHEALTHY;
    }
}

