/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.shared;

import io.camunda.zeebe.broker.shared.WorkingDirectoryConfiguration;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.gateway.impl.configuration.ExperimentalCfg;
import io.camunda.zeebe.gateway.impl.configuration.MultiTenancyCfg;
import io.camunda.zeebe.gateway.rest.ConditionalOnRestGatewayEnabled;
import java.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.context.LifecycleProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={BrokerProperties.class})
public final class BrokerConfiguration {
    private final WorkingDirectoryConfiguration.WorkingDirectory workingDirectory;
    private final BrokerCfg properties;
    private final LifecycleProperties lifecycle;

    @Autowired
    public BrokerConfiguration(WorkingDirectoryConfiguration.WorkingDirectory workingDirectory, BrokerProperties properties, LifecycleProperties lifecycle) {
        this.workingDirectory = workingDirectory;
        this.properties = properties;
        this.lifecycle = lifecycle;
        properties.init(workingDirectory.path().toAbsolutePath().toString());
    }

    public BrokerCfg config() {
        return this.properties;
    }

    public WorkingDirectoryConfiguration.WorkingDirectory workingDirectory() {
        return this.workingDirectory;
    }

    @ConditionalOnProperty(prefix="zeebe.broker.gateway", name={"enable"}, havingValue="false")
    @Bean
    public ConditionalOnRestGatewayEnabled.RestGatewayDisabled disableRestGateway() {
        return new ConditionalOnRestGatewayEnabled.RestGatewayDisabled();
    }

    public Duration shutdownTimeout() {
        return this.lifecycle.getTimeoutPerShutdownPhase();
    }

    @Bean
    public MultiTenancyCfg multiTenancyCfg() {
        return this.properties.getGateway().getMultiTenancy();
    }

    @Bean
    public ExperimentalCfg experimentalCfg() {
        return this.properties.getGateway().getExperimental();
    }

    @ConfigurationProperties(value="zeebe.broker")
    public static final class BrokerProperties
    extends BrokerCfg {
    }
}

