/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.shared;

import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.shared.Profile;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;

@Configuration(proxyBeanMethods=false)
public record WorkingDirectoryConfiguration(Environment environment) {
    @Bean
    public WorkingDirectory workingDirectory() {
        if (this.shouldUseTemporaryFolder()) {
            Path workingDirectory;
            Loggers.SYSTEM_LOGGER.info("Started with development/test mode; data will be deleted on shutdown");
            try {
                workingDirectory = Files.createTempDirectory("zeebe", new FileAttribute[0]).toAbsolutePath().normalize();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to start with temporary directory", e);
            }
            return new WorkingDirectory(workingDirectory, true);
        }
        Path workingDirectory = Path.of(this.environment.getProperty("basedir", "."), new String[0]).toAbsolutePath().normalize();
        return new WorkingDirectory(workingDirectory, false);
    }

    private boolean shouldUseTemporaryFolder() {
        return this.environment.acceptsProfiles(Profiles.of((String[])new String[]{Profile.DEVELOPMENT.getId(), Profile.TEST.getId()}));
    }

    public record WorkingDirectory(Path path, boolean isTemporary) {
    }
}

