/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway;

import io.atomix.cluster.AtomixCluster;
import io.camunda.zeebe.broker.client.api.BrokerClient;
import io.camunda.zeebe.broker.client.api.BrokerClientRequestMetrics;
import io.camunda.zeebe.broker.client.api.BrokerTopologyManager;
import io.camunda.zeebe.broker.client.impl.BrokerClientImpl;
import io.camunda.zeebe.gateway.GatewayConfiguration;
import io.camunda.zeebe.gateway.impl.configuration.GatewayCfg;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public final class BrokerClientComponent {
    private final GatewayCfg config;
    private final AtomixCluster atomixCluster;
    private final ActorScheduler actorScheduler;
    private final BrokerTopologyManager topologyManager;
    private final BrokerClientRequestMetrics metrics;

    @Autowired
    public BrokerClientComponent(GatewayConfiguration config, AtomixCluster atomixCluster, ActorScheduler actorScheduler, BrokerTopologyManager topologyManager, MeterRegistry registry) {
        this.config = config.config();
        this.atomixCluster = atomixCluster;
        this.actorScheduler = actorScheduler;
        this.topologyManager = topologyManager;
        this.metrics = BrokerClientRequestMetrics.of((MeterRegistry)registry);
    }

    @Bean(destroyMethod="close")
    public BrokerClient brokerClient() {
        BrokerClientImpl brokerClient = new BrokerClientImpl(this.config.getCluster().getRequestTimeout(), this.atomixCluster.getMessagingService(), this.atomixCluster.getEventService(), (ActorSchedulingService)this.actorScheduler, this.topologyManager, this.metrics);
        brokerClient.start().forEach(ActorFuture::join);
        return brokerClient;
    }
}

