/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway;

import io.atomix.cluster.AtomixCluster;
import io.atomix.cluster.ClusterConfig;
import io.atomix.cluster.MemberConfig;
import io.atomix.cluster.NodeConfig;
import io.atomix.cluster.discovery.BootstrapDiscoveryConfig;
import io.atomix.cluster.discovery.NodeDiscoveryConfig;
import io.atomix.cluster.messaging.MessagingConfig;
import io.atomix.cluster.protocol.GroupMembershipProtocolConfig;
import io.atomix.cluster.protocol.SwimMembershipProtocolConfig;
import io.atomix.utils.Version;
import io.atomix.utils.net.Address;
import io.camunda.zeebe.gateway.GatewayConfiguration;
import io.camunda.zeebe.gateway.impl.configuration.ClusterCfg;
import io.camunda.zeebe.gateway.impl.configuration.GatewayCfg;
import io.camunda.zeebe.gateway.impl.configuration.MembershipCfg;
import io.camunda.zeebe.gateway.impl.configuration.SecurityCfg;
import io.camunda.zeebe.util.VersionUtil;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public final class GatewayClusterConfiguration {
    private MeterRegistry meterRegistry;

    @Bean
    public ClusterConfig clusterConfig(GatewayConfiguration gatewayConfig, MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
        GatewayConfiguration.GatewayProperties config = gatewayConfig.config();
        ClusterCfg cluster = config.getCluster();
        String name = cluster.getClusterName();
        MessagingConfig messaging = this.messagingConfig(config);
        BootstrapDiscoveryConfig discovery = this.discoveryConfig(cluster.getInitialContactPoints());
        SwimMembershipProtocolConfig membership = this.membershipConfig(cluster.getMembership());
        MemberConfig member = this.memberConfig(cluster);
        return new ClusterConfig().setClusterId(name).setNodeConfig(member).setDiscoveryConfig((NodeDiscoveryConfig)discovery).setMessagingConfig(messaging).setProtocolConfig((GroupMembershipProtocolConfig)membership);
    }

    @Bean(destroyMethod="stop")
    public AtomixCluster atomixCluster(ClusterConfig config) {
        return new AtomixCluster(config, Version.from((String)VersionUtil.getVersion()), this.meterRegistry);
    }

    private MemberConfig memberConfig(ClusterCfg cluster) {
        Address advertisedAddress = Address.from((String)cluster.getAdvertisedHost(), (int)cluster.getAdvertisedPort());
        return new MemberConfig().setId(cluster.getMemberId()).setAddress(advertisedAddress);
    }

    private SwimMembershipProtocolConfig membershipConfig(MembershipCfg config) {
        return new SwimMembershipProtocolConfig().setBroadcastDisputes(config.isBroadcastDisputes()).setBroadcastUpdates(config.isBroadcastUpdates()).setFailureTimeout(config.getFailureTimeout()).setGossipFanout(config.getGossipFanout()).setGossipInterval(config.getGossipInterval()).setNotifySuspect(config.isNotifySuspect()).setProbeInterval(config.getProbeInterval()).setProbeTimeout(config.getProbeTimeout()).setSuspectProbes(config.getSuspectProbes()).setSyncInterval(config.getSyncInterval());
    }

    private BootstrapDiscoveryConfig discoveryConfig(Collection<String> contactPoints) {
        Set nodes = contactPoints.stream().map(Address::from).map(address -> new NodeConfig().setAddress(address)).collect(Collectors.toSet());
        return new BootstrapDiscoveryConfig().setNodes(nodes);
    }

    private MessagingConfig messagingConfig(GatewayCfg config) {
        ClusterCfg cluster = config.getCluster();
        MessagingConfig messaging = new MessagingConfig().setCompressionAlgorithm(cluster.getMessageCompression()).setInterfaces(Collections.singletonList(cluster.getHost())).setPort(Integer.valueOf(cluster.getPort()));
        SecurityCfg security = cluster.getSecurity();
        if (security.isEnabled()) {
            messaging.setTlsEnabled(true).setCertificateChain(security.getCertificateChainPath()).setPrivateKey(security.getPrivateKeyPath());
        }
        return messaging;
    }
}

