/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway;

import io.camunda.zeebe.gateway.impl.configuration.ExperimentalCfg;
import io.camunda.zeebe.gateway.impl.configuration.GatewayCfg;
import io.camunda.zeebe.gateway.impl.configuration.MultiTenancyCfg;
import java.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.context.LifecycleProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={GatewayProperties.class})
public final class GatewayConfiguration {
    private final GatewayProperties config;
    private final LifecycleProperties lifecycleProperties;

    @Autowired
    public GatewayConfiguration(GatewayProperties config, LifecycleProperties lifecycleProperties) {
        this.config = config;
        this.lifecycleProperties = lifecycleProperties;
        config.init();
    }

    public GatewayProperties config() {
        return this.config;
    }

    public Duration shutdownTimeout() {
        return this.lifecycleProperties.getTimeoutPerShutdownPhase();
    }

    @Bean
    public MultiTenancyCfg multiTenancyCfg() {
        return this.config.getMultiTenancy();
    }

    @Bean
    public ExperimentalCfg experimentalCfg() {
        return this.config.getExperimental();
    }

    @ConfigurationProperties(value="zeebe.gateway")
    public static final class GatewayProperties
    extends GatewayCfg {
    }
}

