/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway;

import io.atomix.cluster.AtomixCluster;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.utils.event.EventListener;
import io.camunda.zeebe.broker.client.api.BrokerClientTopologyMetrics;
import io.camunda.zeebe.broker.client.api.BrokerTopologyManager;
import io.camunda.zeebe.broker.client.impl.BrokerTopologyManagerImpl;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.topology.GatewayClusterTopologyService;
import io.camunda.zeebe.topology.TopologyUpdateNotifier;
import io.camunda.zeebe.topology.api.TopologyCoordinatorSupplier;
import io.camunda.zeebe.topology.api.TopologyManagementRequestSender;
import io.camunda.zeebe.topology.gossip.ClusterTopologyGossiperConfig;
import io.camunda.zeebe.topology.serializer.ProtoBufSerializer;
import io.camunda.zeebe.topology.serializer.TopologyRequestsSerializer;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class TopologyServices {
    private final ActorScheduler scheduler;
    private final ClusterMembershipService clusterMembershipService;
    private final ClusterCommunicationService clusterCommunicationService;
    private final BrokerClientTopologyMetrics brokerClientTopologyMetrics;
    private final MeterRegistry meterRegistry;

    @Autowired
    public TopologyServices(ActorScheduler scheduler, AtomixCluster atomixCluster, MeterRegistry registry) {
        this.scheduler = scheduler;
        this.clusterMembershipService = atomixCluster.getMembershipService();
        this.clusterCommunicationService = atomixCluster.getCommunicationService();
        this.brokerClientTopologyMetrics = BrokerClientTopologyMetrics.of((MeterRegistry)registry);
        this.meterRegistry = registry;
    }

    @Bean
    GatewayClusterTopologyService gatewayClusterTopologyService() {
        GatewayClusterTopologyService service = new GatewayClusterTopologyService(this.clusterCommunicationService, this.clusterMembershipService, new ClusterTopologyGossiperConfig(false, Duration.ofSeconds(10L), Duration.ofSeconds(1L), 2), this.meterRegistry);
        this.scheduler.submitActor((Actor)service).join();
        return service;
    }

    @Bean
    BrokerTopologyManager brokerTopologyManager(@Autowired GatewayClusterTopologyService gatewayClusterTopologyService) {
        BrokerTopologyManagerImpl brokerTopologyManager = new BrokerTopologyManagerImpl(() -> ((ClusterMembershipService)this.clusterMembershipService).getMembers(), this.brokerClientTopologyMetrics);
        this.scheduler.submitActor((Actor)brokerTopologyManager).join();
        this.clusterMembershipService.addListener((EventListener)brokerTopologyManager);
        gatewayClusterTopologyService.addUpdateListener((TopologyUpdateNotifier.TopologyUpdateListener)brokerTopologyManager);
        return brokerTopologyManager;
    }

    @Bean
    TopologyManagementRequestSender topologyManagementRequestSender(BrokerTopologyManager brokerTopologyManager) {
        return new TopologyManagementRequestSender(this.clusterCommunicationService, (TopologyCoordinatorSupplier)new TopologyCoordinatorSupplier.ClusterTopologyAwareCoordinatorSupplier(() -> ((BrokerTopologyManager)brokerTopologyManager).getClusterTopology()), (TopologyRequestsSerializer)new ProtoBufSerializer());
    }
}

