/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.management.backups;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.management.backups.PartitionBackupInfo;
import io.camunda.zeebe.management.backups.StateCode;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(name="BackupInfo", description="Detailed status of a backup. The aggregated state is computed from the backup state of each partition as: - If the backup of all partitions is in state 'COMPLETED', then the overall state is 'COMPLETED'. - If one is 'FAILED', then the overall state is 'FAILED'. - Otherwise, if one is 'DOES_NOT_EXIST', then the overall state is 'INCOMPLETE'. - Otherwise, if one is 'IN_PROGRESS', then the overall state is 'IN_PROGRESS'. ")
public class BackupInfo {
    private Long backupId;
    private StateCode state;
    private String failureReason;
    @Valid
    private @Valid List<@Valid PartitionBackupInfo> details = new ArrayList<PartitionBackupInfo>();

    public BackupInfo() {
    }

    public BackupInfo(Long backupId, StateCode state, List<@Valid PartitionBackupInfo> details) {
        this.backupId = backupId;
        this.state = state;
        this.details = details;
    }

    public BackupInfo backupId(Long backupId) {
        this.backupId = backupId;
        return this;
    }

    @Min(value=0L)
    @Schema(name="backupId", accessMode=Schema.AccessMode.READ_ONLY, example="1", description="The ID of the backup. The ID of the backup must be a positive numerical value. As backups are logically ordered by their IDs (ascending), each successive backup must use a higher ID than the previous one. ", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="backupId")
    public @Min(value=0L) Long getBackupId() {
        return this.backupId;
    }

    public void setBackupId(Long backupId) {
        this.backupId = backupId;
    }

    public BackupInfo state(StateCode state) {
        this.state = state;
        return this;
    }

    @Valid
    @Schema(name="state", accessMode=Schema.AccessMode.READ_ONLY, requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="state")
    public StateCode getState() {
        return this.state;
    }

    public void setState(StateCode state) {
        this.state = state;
    }

    public BackupInfo failureReason(String failureReason) {
        this.failureReason = failureReason;
        return this;
    }

    @Schema(name="failureReason", example="", description="Reason for failure if the state is 'FAILED'", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="failureReason")
    public String getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public BackupInfo details(List<@Valid PartitionBackupInfo> details) {
        this.details = details;
        return this;
    }

    public BackupInfo addDetailsItem(PartitionBackupInfo detailsItem) {
        if (this.details == null) {
            this.details = new ArrayList<PartitionBackupInfo>();
        }
        this.details.add(detailsItem);
        return this;
    }

    @Valid
    @Schema(name="details", accessMode=Schema.AccessMode.READ_ONLY, description="Detailed list of the status of the backup per partition. It should always contain all partitions known to the cluster. ", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="details")
    public @Valid List<@Valid PartitionBackupInfo> getDetails() {
        return this.details;
    }

    public void setDetails(List<@Valid PartitionBackupInfo> details) {
        this.details = details;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackupInfo backupInfo = (BackupInfo)o;
        return Objects.equals(this.backupId, backupInfo.backupId) && Objects.equals((Object)this.state, (Object)backupInfo.state) && Objects.equals(this.failureReason, backupInfo.failureReason) && Objects.equals(this.details, backupInfo.details);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.backupId, this.state, this.failureReason, this.details});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BackupInfo {\n");
        sb.append("    backupId: ").append(this.toIndentedString(this.backupId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    failureReason: ").append(this.toIndentedString(this.failureReason)).append("\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

