/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.management.backups;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(name="TakeBackupRequest", description="Request body for take backup")
public class TakeBackupRequest {
    private Long backupId;

    public TakeBackupRequest() {
    }

    public TakeBackupRequest(Long backupId) {
        this.backupId = backupId;
    }

    public TakeBackupRequest backupId(Long backupId) {
        this.backupId = backupId;
        return this;
    }

    @NotNull
    @Min(value=0L)
    @Schema(name="backupId", example="1", description="The ID of the backup to be taken", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="backupId")
    public @NotNull @Min(value=0L) Long getBackupId() {
        return this.backupId;
    }

    public void setBackupId(Long backupId) {
        this.backupId = backupId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TakeBackupRequest takeBackupRequest = (TakeBackupRequest)o;
        return Objects.equals(this.backupId, takeBackupRequest.backupId);
    }

    public int hashCode() {
        return Objects.hash(this.backupId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TakeBackupRequest {\n");
        sb.append("    backupId: ").append(this.toIndentedString(this.backupId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

