/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.management.cluster;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.management.cluster.BrokerStateCode;
import io.camunda.zeebe.management.cluster.PartitionState;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.format.annotation.DateTimeFormat;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(name="BrokerState", description="State of a broker")
public class BrokerState {
    private Integer id;
    private BrokerStateCode state;
    private Long version;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime lastUpdatedAt;
    @Valid
    private @Valid List<@Valid PartitionState> partitions;

    public BrokerState id(Integer id) {
        this.id = id;
        return this;
    }

    @Schema(name="id", example="0", description="The ID of a broker, starting from 0", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public BrokerState state(BrokerStateCode state) {
        this.state = state;
        return this;
    }

    @Valid
    @Schema(name="state", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="state")
    public BrokerStateCode getState() {
        return this.state;
    }

    public void setState(BrokerStateCode state) {
        this.state = state;
    }

    public BrokerState version(Long version) {
        this.version = version;
        return this;
    }

    @Schema(name="version", example="1", description="The version of the broker state", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="version")
    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public BrokerState lastUpdatedAt(OffsetDateTime lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
        return this;
    }

    @Valid
    @Schema(name="lastUpdatedAt", example="2020-01-01T00:00Z", description="The time when the broker state was last updated", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="lastUpdatedAt")
    public OffsetDateTime getLastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public void setLastUpdatedAt(OffsetDateTime lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
    }

    public BrokerState partitions(List<@Valid PartitionState> partitions) {
        this.partitions = partitions;
        return this;
    }

    public BrokerState addPartitionsItem(PartitionState partitionsItem) {
        if (this.partitions == null) {
            this.partitions = new ArrayList<PartitionState>();
        }
        this.partitions.add(partitionsItem);
        return this;
    }

    @Valid
    @Schema(name="partitions", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="partitions")
    public @Valid List<@Valid PartitionState> getPartitions() {
        return this.partitions;
    }

    public void setPartitions(List<@Valid PartitionState> partitions) {
        this.partitions = partitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrokerState brokerState = (BrokerState)o;
        return Objects.equals(this.id, brokerState.id) && Objects.equals((Object)this.state, (Object)brokerState.state) && Objects.equals(this.version, brokerState.version) && Objects.equals(this.lastUpdatedAt, brokerState.lastUpdatedAt) && Objects.equals(this.partitions, brokerState.partitions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.state, this.version, this.lastUpdatedAt, this.partitions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BrokerState {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    lastUpdatedAt: ").append(this.toIndentedString(this.lastUpdatedAt)).append("\n");
        sb.append("    partitions: ").append(this.toIndentedString(this.partitions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

