/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.management.cluster;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.springframework.format.annotation.DateTimeFormat;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CompletedChange {
    private Long id;
    private StatusEnum status;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime startedAt;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime completedAt;

    public CompletedChange id(Long id) {
        this.id = id;
        return this;
    }

    @Schema(name="id", example="8", description="The ID of a topology change operation", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public CompletedChange status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Schema(name="status", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public CompletedChange startedAt(OffsetDateTime startedAt) {
        this.startedAt = startedAt;
        return this;
    }

    @Valid
    @Schema(name="startedAt", example="2020-01-01T00:00Z", description="The time when the topology change was started", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="startedAt")
    public OffsetDateTime getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(OffsetDateTime startedAt) {
        this.startedAt = startedAt;
    }

    public CompletedChange completedAt(OffsetDateTime completedAt) {
        this.completedAt = completedAt;
        return this;
    }

    @Valid
    @Schema(name="completedAt", example="2020-01-01T00:00Z", description="The time when the topology change was completed", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="completedAt")
    public OffsetDateTime getCompletedAt() {
        return this.completedAt;
    }

    public void setCompletedAt(OffsetDateTime completedAt) {
        this.completedAt = completedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompletedChange completedChange = (CompletedChange)o;
        return Objects.equals(this.id, completedChange.id) && Objects.equals((Object)this.status, (Object)completedChange.status) && Objects.equals(this.startedAt, completedChange.startedAt) && Objects.equals(this.completedAt, completedChange.completedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.status, this.startedAt, this.completedAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CompletedChange {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    startedAt: ").append(this.toIndentedString(this.startedAt)).append("\n");
        sb.append("    completedAt: ").append(this.toIndentedString(this.completedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        COMPLETED("COMPLETED"),
        FAILED("FAILED"),
        CANCELLED("CANCELLED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

