/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.management.cluster;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.management.cluster.BrokerState;
import io.camunda.zeebe.management.cluster.CompletedChange;
import io.camunda.zeebe.management.cluster.TopologyChange;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(name="GetTopologyResponse", description="Current topology of the cluster")
public class GetTopologyResponse {
    private Long version;
    @Valid
    private @Valid List<@Valid BrokerState> brokers;
    private CompletedChange lastChange;
    private TopologyChange pendingChange;

    public GetTopologyResponse version(Long version) {
        this.version = version;
        return this;
    }

    @Schema(name="version", example="1", description="The version of the topology", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="version")
    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public GetTopologyResponse brokers(List<@Valid BrokerState> brokers) {
        this.brokers = brokers;
        return this;
    }

    public GetTopologyResponse addBrokersItem(BrokerState brokersItem) {
        if (this.brokers == null) {
            this.brokers = new ArrayList<BrokerState>();
        }
        this.brokers.add(brokersItem);
        return this;
    }

    @Valid
    @Schema(name="brokers", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="brokers")
    public @Valid List<@Valid BrokerState> getBrokers() {
        return this.brokers;
    }

    public void setBrokers(List<@Valid BrokerState> brokers) {
        this.brokers = brokers;
    }

    public GetTopologyResponse lastChange(CompletedChange lastChange) {
        this.lastChange = lastChange;
        return this;
    }

    @Valid
    @Schema(name="lastChange", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="lastChange")
    public CompletedChange getLastChange() {
        return this.lastChange;
    }

    public void setLastChange(CompletedChange lastChange) {
        this.lastChange = lastChange;
    }

    public GetTopologyResponse pendingChange(TopologyChange pendingChange) {
        this.pendingChange = pendingChange;
        return this;
    }

    @Valid
    @Schema(name="pendingChange", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="pendingChange")
    public TopologyChange getPendingChange() {
        return this.pendingChange;
    }

    public void setPendingChange(TopologyChange pendingChange) {
        this.pendingChange = pendingChange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTopologyResponse getTopologyResponse = (GetTopologyResponse)o;
        return Objects.equals(this.version, getTopologyResponse.version) && Objects.equals(this.brokers, getTopologyResponse.brokers) && Objects.equals(this.lastChange, getTopologyResponse.lastChange) && Objects.equals(this.pendingChange, getTopologyResponse.pendingChange);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.brokers, this.lastChange, this.pendingChange);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetTopologyResponse {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    brokers: ").append(this.toIndentedString(this.brokers)).append("\n");
        sb.append("    lastChange: ").append(this.toIndentedString(this.lastChange)).append("\n");
        sb.append("    pendingChange: ").append(this.toIndentedString(this.pendingChange)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

