/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.management.cluster;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Operation {
    private OperationEnum operation;
    private Integer brokerId;
    private Integer partitionId;
    private Integer priority;
    @Valid
    private List<Integer> brokers;

    public Operation operation(OperationEnum operation) {
        this.operation = operation;
        return this;
    }

    @Schema(name="operation", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="operation")
    public OperationEnum getOperation() {
        return this.operation;
    }

    public void setOperation(OperationEnum operation) {
        this.operation = operation;
    }

    public Operation brokerId(Integer brokerId) {
        this.brokerId = brokerId;
        return this;
    }

    @Schema(name="brokerId", example="0", description="The ID of a broker, starting from 0", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="brokerId")
    public Integer getBrokerId() {
        return this.brokerId;
    }

    public void setBrokerId(Integer brokerId) {
        this.brokerId = brokerId;
    }

    public Operation partitionId(Integer partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    @Schema(name="partitionId", example="1", description="The ID of a partition, starting from 1", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="partitionId")
    public Integer getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(Integer partitionId) {
        this.partitionId = partitionId;
    }

    public Operation priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @Schema(name="priority", example="3", description="The priority of the partition", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="priority")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Operation brokers(List<Integer> brokers) {
        this.brokers = brokers;
        return this;
    }

    public Operation addBrokersItem(Integer brokersItem) {
        if (this.brokers == null) {
            this.brokers = new ArrayList<Integer>();
        }
        this.brokers.add(brokersItem);
        return this;
    }

    @Schema(name="brokers", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="brokers")
    public List<Integer> getBrokers() {
        return this.brokers;
    }

    public void setBrokers(List<Integer> brokers) {
        this.brokers = brokers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Operation operation = (Operation)o;
        return Objects.equals((Object)this.operation, (Object)operation.operation) && Objects.equals(this.brokerId, operation.brokerId) && Objects.equals(this.partitionId, operation.partitionId) && Objects.equals(this.priority, operation.priority) && Objects.equals(this.brokers, operation.brokers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operation, this.brokerId, this.partitionId, this.priority, this.brokers});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Operation {\n");
        sb.append("    operation: ").append(this.toIndentedString((Object)this.operation)).append("\n");
        sb.append("    brokerId: ").append(this.toIndentedString(this.brokerId)).append("\n");
        sb.append("    partitionId: ").append(this.toIndentedString(this.partitionId)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    brokers: ").append(this.toIndentedString(this.brokers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OperationEnum {
        BROKER_ADD("BROKER_ADD"),
        BROKER_REMOVE("BROKER_REMOVE"),
        PARTITION_JOIN("PARTITION_JOIN"),
        PARTITION_LEAVE("PARTITION_LEAVE"),
        PARTITION_RECONFIGURE_PRIORITY("PARTITION_RECONFIGURE_PRIORITY"),
        PARTITION_FORCE_RECONFIGURE("PARTITION_FORCE_RECONFIGURE"),
        BROKER_FORCE_REMOVE("BROKER_FORCE_REMOVE");

        private String value;

        private OperationEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OperationEnum fromValue(String value) {
            for (OperationEnum b : OperationEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

