/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.management.cluster;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.management.cluster.PartitionStateCode;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PartitionState {
    private Integer id;
    private PartitionStateCode state;
    private Integer priority;

    public PartitionState id(Integer id) {
        this.id = id;
        return this;
    }

    @Schema(name="id", example="1", description="The ID of a partition, starting from 1", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public PartitionState state(PartitionStateCode state) {
        this.state = state;
        return this;
    }

    @Valid
    @Schema(name="state", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="state")
    public PartitionStateCode getState() {
        return this.state;
    }

    public void setState(PartitionStateCode state) {
        this.state = state;
    }

    public PartitionState priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @Schema(name="priority", example="1", description="The priority of the partition", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="priority")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionState partitionState = (PartitionState)o;
        return Objects.equals(this.id, partitionState.id) && Objects.equals((Object)this.state, (Object)partitionState.state) && Objects.equals(this.priority, partitionState.priority);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.state, this.priority});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PartitionState {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

