/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.management.cluster;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.management.cluster.BrokerState;
import io.camunda.zeebe.management.cluster.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(name="PlannedOperationsResponse", description="Returns the current topology, planned changes and the expected final topology when the planned changes have completed.")
public class PlannedOperationsResponse {
    private Long changeId;
    @Valid
    private @Valid List<@Valid BrokerState> currentTopology;
    @Valid
    private @Valid List<@Valid Operation> plannedChanges;
    @Valid
    private @Valid List<@Valid BrokerState> expectedTopology;

    public PlannedOperationsResponse changeId(Long changeId) {
        this.changeId = changeId;
        return this;
    }

    @Schema(name="changeId", example="8", description="The ID of a topology change operation", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="changeId")
    public Long getChangeId() {
        return this.changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public PlannedOperationsResponse currentTopology(List<@Valid BrokerState> currentTopology) {
        this.currentTopology = currentTopology;
        return this;
    }

    public PlannedOperationsResponse addCurrentTopologyItem(BrokerState currentTopologyItem) {
        if (this.currentTopology == null) {
            this.currentTopology = new ArrayList<BrokerState>();
        }
        this.currentTopology.add(currentTopologyItem);
        return this;
    }

    @Valid
    @Schema(name="currentTopology", description="Current topology of the cluster", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="currentTopology")
    public @Valid List<@Valid BrokerState> getCurrentTopology() {
        return this.currentTopology;
    }

    public void setCurrentTopology(List<@Valid BrokerState> currentTopology) {
        this.currentTopology = currentTopology;
    }

    public PlannedOperationsResponse plannedChanges(List<@Valid Operation> plannedChanges) {
        this.plannedChanges = plannedChanges;
        return this;
    }

    public PlannedOperationsResponse addPlannedChangesItem(Operation plannedChangesItem) {
        if (this.plannedChanges == null) {
            this.plannedChanges = new ArrayList<Operation>();
        }
        this.plannedChanges.add(plannedChangesItem);
        return this;
    }

    @Valid
    @Schema(name="plannedChanges", description="A sequence of operations that will be performed to transform the current topology into the expected topology.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="plannedChanges")
    public @Valid List<@Valid Operation> getPlannedChanges() {
        return this.plannedChanges;
    }

    public void setPlannedChanges(List<@Valid Operation> plannedChanges) {
        this.plannedChanges = plannedChanges;
    }

    public PlannedOperationsResponse expectedTopology(List<@Valid BrokerState> expectedTopology) {
        this.expectedTopology = expectedTopology;
        return this;
    }

    public PlannedOperationsResponse addExpectedTopologyItem(BrokerState expectedTopologyItem) {
        if (this.expectedTopology == null) {
            this.expectedTopology = new ArrayList<BrokerState>();
        }
        this.expectedTopology.add(expectedTopologyItem);
        return this;
    }

    @Valid
    @Schema(name="expectedTopology", description="The expected final topology when the planned changes have completed.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="expectedTopology")
    public @Valid List<@Valid BrokerState> getExpectedTopology() {
        return this.expectedTopology;
    }

    public void setExpectedTopology(List<@Valid BrokerState> expectedTopology) {
        this.expectedTopology = expectedTopology;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlannedOperationsResponse plannedOperationsResponse = (PlannedOperationsResponse)o;
        return Objects.equals(this.changeId, plannedOperationsResponse.changeId) && Objects.equals(this.currentTopology, plannedOperationsResponse.currentTopology) && Objects.equals(this.plannedChanges, plannedOperationsResponse.plannedChanges) && Objects.equals(this.expectedTopology, plannedOperationsResponse.expectedTopology);
    }

    public int hashCode() {
        return Objects.hash(this.changeId, this.currentTopology, this.plannedChanges, this.expectedTopology);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PlannedOperationsResponse {\n");
        sb.append("    changeId: ").append(this.toIndentedString(this.changeId)).append("\n");
        sb.append("    currentTopology: ").append(this.toIndentedString(this.currentTopology)).append("\n");
        sb.append("    plannedChanges: ").append(this.toIndentedString(this.plannedChanges)).append("\n");
        sb.append("    expectedTopology: ").append(this.toIndentedString(this.expectedTopology)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

