/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.management.cluster;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.zeebe.management.cluster.Operation;
import io.camunda.zeebe.management.cluster.TopologyChangeCompletedInner;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.format.annotation.DateTimeFormat;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TopologyChange {
    private Long id;
    private StatusEnum status;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime startedAt;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime completedAt;
    private Long internalVersion;
    @Valid
    private List<TopologyChangeCompletedInner> completed;
    @Valid
    private @Valid List<@Valid Operation> pending;

    public TopologyChange id(Long id) {
        this.id = id;
        return this;
    }

    @Schema(name="id", example="8", description="The ID of a topology change operation", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public TopologyChange status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Schema(name="status", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public TopologyChange startedAt(OffsetDateTime startedAt) {
        this.startedAt = startedAt;
        return this;
    }

    @Valid
    @Schema(name="startedAt", example="2020-01-01T00:00Z", description="The time when the topology change was started", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="startedAt")
    public OffsetDateTime getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(OffsetDateTime startedAt) {
        this.startedAt = startedAt;
    }

    public TopologyChange completedAt(OffsetDateTime completedAt) {
        this.completedAt = completedAt;
        return this;
    }

    @Valid
    @Schema(name="completedAt", example="2020-01-01T00:00Z", description="The time when the topology change was completed", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="completedAt")
    public OffsetDateTime getCompletedAt() {
        return this.completedAt;
    }

    public void setCompletedAt(OffsetDateTime completedAt) {
        this.completedAt = completedAt;
    }

    public TopologyChange internalVersion(Long internalVersion) {
        this.internalVersion = internalVersion;
        return this;
    }

    @Schema(name="internalVersion", example="1", description="The internal version of the topology change", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="internalVersion")
    public Long getInternalVersion() {
        return this.internalVersion;
    }

    public void setInternalVersion(Long internalVersion) {
        this.internalVersion = internalVersion;
    }

    public TopologyChange completed(List<TopologyChangeCompletedInner> completed) {
        this.completed = completed;
        return this;
    }

    public TopologyChange addCompletedItem(TopologyChangeCompletedInner completedItem) {
        if (this.completed == null) {
            this.completed = new ArrayList<TopologyChangeCompletedInner>();
        }
        this.completed.add(completedItem);
        return this;
    }

    @Valid
    @Schema(name="completed", description="The list of operations that have been completed if the change status is not COMPLETED.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="completed")
    public List<TopologyChangeCompletedInner> getCompleted() {
        return this.completed;
    }

    public void setCompleted(List<TopologyChangeCompletedInner> completed) {
        this.completed = completed;
    }

    public TopologyChange pending(List<@Valid Operation> pending) {
        this.pending = pending;
        return this;
    }

    public TopologyChange addPendingItem(Operation pendingItem) {
        if (this.pending == null) {
            this.pending = new ArrayList<Operation>();
        }
        this.pending.add(pendingItem);
        return this;
    }

    @Valid
    @Schema(name="pending", description="The list of operations that are pending.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="pending")
    public @Valid List<@Valid Operation> getPending() {
        return this.pending;
    }

    public void setPending(List<@Valid Operation> pending) {
        this.pending = pending;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopologyChange topologyChange = (TopologyChange)o;
        return Objects.equals(this.id, topologyChange.id) && Objects.equals((Object)this.status, (Object)topologyChange.status) && Objects.equals(this.startedAt, topologyChange.startedAt) && Objects.equals(this.completedAt, topologyChange.completedAt) && Objects.equals(this.internalVersion, topologyChange.internalVersion) && Objects.equals(this.completed, topologyChange.completed) && Objects.equals(this.pending, topologyChange.pending);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.status, this.startedAt, this.completedAt, this.internalVersion, this.completed, this.pending});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TopologyChange {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    startedAt: ").append(this.toIndentedString(this.startedAt)).append("\n");
        sb.append("    completedAt: ").append(this.toIndentedString(this.completedAt)).append("\n");
        sb.append("    internalVersion: ").append(this.toIndentedString(this.internalVersion)).append("\n");
        sb.append("    completed: ").append(this.toIndentedString(this.completed)).append("\n");
        sb.append("    pending: ").append(this.toIndentedString(this.pending)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        IN_PROGRESS("IN_PROGRESS"),
        COMPLETED("COMPLETED"),
        FAILED("FAILED"),
        CANCELLED("CANCELLED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

