/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.restore;

import io.camunda.zeebe.backup.api.BackupStore;
import io.camunda.zeebe.broker.shared.BrokerConfiguration;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.restore.RestoreConfiguration;
import io.camunda.zeebe.restore.RestoreManager;
import io.camunda.zeebe.shared.MainSupport;
import io.camunda.zeebe.shared.Profile;
import io.micrometer.core.instrument.MeterRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.ConfigurationPropertiesScan;

@SpringBootApplication(scanBasePackages={"io.camunda.zeebe.restore", "io.camunda.zeebe.broker.shared"})
@ConfigurationPropertiesScan(basePackages={"io.camunda.zeebe.broker.shared", "io.camunda.zeebe.restore"})
public class RestoreApp
implements ApplicationRunner {
    private static final Logger LOG = LoggerFactory.getLogger(RestoreApp.class);
    private final BrokerCfg configuration;
    private final BackupStore backupStore;
    @Value(value="${backupId}")
    private long backupId;
    private final RestoreConfiguration restoreConfiguration;
    private final MeterRegistry meterRegistry;

    @Autowired
    public RestoreApp(BrokerConfiguration configuration, BackupStore backupStore, RestoreConfiguration restoreConfiguration, MeterRegistry meterRegistry) {
        this.configuration = configuration.config();
        this.backupStore = backupStore;
        this.restoreConfiguration = restoreConfiguration;
        this.meterRegistry = meterRegistry;
    }

    public static void main(String[] args) {
        MainSupport.setDefaultGlobalConfiguration();
        SpringApplication application = MainSupport.createDefaultApplicationBuilder().web(WebApplicationType.NONE).sources(new Class[]{RestoreApp.class}).profiles(new String[]{Profile.RESTORE.getId()}).build();
        application.run(args);
    }

    public void run(ApplicationArguments args) {
        LOG.info("Starting to restore from backup {}", (Object)this.backupId);
        new RestoreManager(this.configuration, this.backupStore, this.meterRegistry).restore(this.backupId, this.restoreConfiguration.validateConfig()).join();
        LOG.info("Successfully restored broker from backup {}", (Object)this.backupId);
    }
}

