/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.shared;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.SanitizableData;
import org.springframework.boot.actuate.endpoint.SanitizingFunction;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@EnableConfigurationProperties(value={ConfigSanitizingProperties.class})
public final class ConfigSanitizingFunction
implements SanitizingFunction {
    private final ConfigSanitizingProperties properties;

    @Autowired
    public ConfigSanitizingFunction(ConfigSanitizingProperties properties) {
        this.properties = properties;
    }

    public SanitizableData apply(SanitizableData data) {
        String key = data.getKey();
        if (data.getValue() == null || key == null) {
            return data;
        }
        for (String keyword : this.properties.keywords()) {
            if (!key.contains(keyword)) continue;
            return data.withSanitizedValue();
        }
        return data;
    }

    @ConfigurationProperties(prefix="management.sanitize")
    public record ConfigSanitizingProperties(List<String> keywords) {
    }
}

