/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.shared;

import java.time.Duration;
import java.util.function.Supplier;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.Nullable;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={IdleStrategyProperties.class})
public final class IdleStrategyConfig {
    private final IdleStrategyProperties properties;

    @Autowired
    public IdleStrategyConfig(IdleStrategyProperties properties) {
        this.properties = properties;
    }

    public IdleStrategyConfig() {
        this(new IdleStrategyProperties(null, null, null, null));
    }

    @Bean
    public IdleStrategySupplier toSupplier() {
        return new IdleStrategySupplier(this.properties.maxSpins(), this.properties.maxYields(), this.properties.minParkPeriodNs(), this.properties.maxParkPeriodNs());
    }

    @ConfigurationProperties(prefix="zeebe.actor.idle")
    public record IdleStrategyProperties(@Nullable Long maxSpins, @Nullable Long maxYields, @Nullable Duration minParkPeriod, @Nullable Duration maxParkPeriod) {
        @Nullable
        private final Long maxSpins;
        @Nullable
        private final Long maxYields;

        public Long maxSpins() {
            return this.maxSpins == null ? 10L : this.maxSpins;
        }

        public Long maxYields() {
            return this.maxYields == null ? 5L : this.maxYields;
        }

        public long minParkPeriodNs() {
            return this.minParkPeriod == null ? 1000L : this.minParkPeriod.toNanos();
        }

        public long maxParkPeriodNs() {
            return this.maxParkPeriod == null ? 20000000L : this.maxParkPeriod.toNanos();
        }
    }

    public record IdleStrategySupplier(long maxSpins, long maxYields, long minParkPeriodNs, long maxParkPeriodNs) implements Supplier<IdleStrategy>
    {
        @Override
        public IdleStrategy get() {
            return new BackoffIdleStrategy(this.maxSpins, this.maxYields, this.minParkPeriodNs, this.maxParkPeriodNs);
        }

        public static IdleStrategySupplier ofDefault() {
            return new IdleStrategySupplier(10L, 5L, 1000L, 20000000L);
        }
    }
}

