/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.shared;

import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.util.error.FatalErrorHandler;
import org.slf4j.Logger;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;

public final class MainSupport {
    private MainSupport() {
    }

    public static void setDefaultGlobalConfiguration() {
        Thread.setDefaultUncaughtExceptionHandler(FatalErrorHandler.uncaughtExceptionHandler((Logger)Loggers.SYSTEM_LOGGER));
        MainSupport.putSystemPropertyIfAbsent("io.grpc.netty.useCustomAllocator", Boolean.toString(false));
        MainSupport.putSystemPropertyIfAbsent("java.util.logging.manager", "org.apache.logging.log4j.jul.LogManager");
    }

    public static SpringApplicationBuilder createDefaultApplicationBuilder() {
        return new SpringApplicationBuilder(new Class[0]).web(WebApplicationType.REACTIVE).logStartupInfo(true);
    }

    public static void putSystemPropertyIfAbsent(String key, String value) {
        if (System.getProperty(key) == null) {
            System.setProperty(key, value);
        }
    }
}

