/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.shared.management;

import io.camunda.zeebe.shared.management.ActorClockService;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.annotation.DeleteOperation;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpoint;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
@WebEndpoint(id="clock")
public class ActorClockEndpoint {
    private static final String PATH_PIN = "pin";
    private static final String PATH_ADD = "add";
    private final ActorClockService service;

    @Autowired
    public ActorClockEndpoint(ActorClockService service) {
        this.service = service;
    }

    @ReadOperation
    public WebEndpointResponse<Response> getCurrentClock() {
        Instant instant = Instant.ofEpochMilli(this.service.epochMilli());
        return new WebEndpointResponse((Object)new Response(instant.toEpochMilli(), instant));
    }

    @WriteOperation
    public WebEndpointResponse<?> modify(@Selector(match=Selector.Match.SINGLE) String operationKey, @Nullable Long epochMilli, @Nullable Long offsetMilli) {
        if (PATH_PIN.equals(operationKey)) {
            return this.pinTime(epochMilli);
        }
        if (PATH_ADD.equals(operationKey)) {
            return this.addTime(offsetMilli);
        }
        return new WebEndpointResponse((Object)String.format("Expected to either `pin` or `add` to the clock, but no operation named `%s` is known; make sure you wrote the correct path", operationKey), 400);
    }

    @DeleteOperation
    public WebEndpointResponse<?> resetTime() {
        Optional<ActorClockService.MutableClock> clock = this.service.mutable();
        if (clock.isEmpty()) {
            return new WebEndpointResponse((Object)"Expected to reset the clock, but the clock is immutable", 403);
        }
        clock.get().resetTime();
        return this.getCurrentClock();
    }

    private WebEndpointResponse<?> pinTime(Long epochMilli) {
        if (epochMilli == null) {
            return new WebEndpointResponse((Object)"Expected pin the clock to the given `epochMilli`, but none given", 400);
        }
        Optional<ActorClockService.MutableClock> clock = this.service.mutable();
        if (clock.isEmpty()) {
            return new WebEndpointResponse((Object)"Expected to pin the clock to the given time, but it is immutable", 403);
        }
        ActorClockService.MutableClock mutableClock = clock.get();
        mutableClock.pinTime(Instant.ofEpochMilli(epochMilli));
        mutableClock.update();
        return this.getCurrentClock();
    }

    private WebEndpointResponse<?> addTime(Long offsetMilli) {
        if (offsetMilli == null) {
            return new WebEndpointResponse((Object)"Expected to add `offsetMilli` to the clock, but none given", 400);
        }
        Optional<ActorClockService.MutableClock> clock = this.service.mutable();
        if (clock.isEmpty()) {
            return new WebEndpointResponse((Object)"Expected to add time to the clock, but it is immutable", 403);
        }
        Duration offset = Duration.of(offsetMilli, ChronoUnit.MILLIS);
        ActorClockService.MutableClock mutableClock = clock.get();
        mutableClock.addTime(offset);
        mutableClock.update();
        return this.getCurrentClock();
    }

    record Response(long epochMilli, Instant instant) {
    }
}

