/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.shared.management;

import io.camunda.zeebe.broker.client.api.BrokerClient;
import io.camunda.zeebe.broker.client.api.BrokerErrorException;
import io.camunda.zeebe.broker.client.api.dto.BrokerError;
import io.camunda.zeebe.gateway.admin.IncompleteTopologyException;
import io.camunda.zeebe.gateway.admin.backup.BackupAlreadyExistException;
import io.camunda.zeebe.gateway.admin.backup.BackupApi;
import io.camunda.zeebe.gateway.admin.backup.BackupRequestHandler;
import io.camunda.zeebe.gateway.admin.backup.BackupStatus;
import io.camunda.zeebe.gateway.admin.backup.PartitionBackupStatus;
import io.camunda.zeebe.gateway.admin.backup.State;
import io.camunda.zeebe.management.backups.BackupInfo;
import io.camunda.zeebe.management.backups.Error;
import io.camunda.zeebe.management.backups.PartitionBackupInfo;
import io.camunda.zeebe.management.backups.StateCode;
import io.camunda.zeebe.management.backups.TakeBackupResponse;
import io.camunda.zeebe.protocol.management.BackupStatusCode;
import io.camunda.zeebe.protocol.record.ErrorCode;
import io.netty.channel.ConnectTimeoutException;
import java.net.ConnectException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeoutException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.annotation.DeleteOperation;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpoint;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
@WebEndpoint(id="backups")
public final class BackupEndpoint {
    private final BackupApi api;

    @Autowired
    public BackupEndpoint(BrokerClient client) {
        this((BackupApi)new BackupRequestHandler(client));
    }

    BackupEndpoint(BackupApi api) {
        this.api = api;
    }

    @WriteOperation
    public WebEndpointResponse<?> take(long backupId) {
        try {
            if (backupId <= 0L) {
                return new WebEndpointResponse((Object)new Error().message("A backupId must be provided and it must be > 0"), 400);
            }
            this.api.takeBackup(backupId).toCompletableFuture().join();
            return new WebEndpointResponse((Object)new TakeBackupResponse().message("A backup with id %d has been scheduled. Use GET actuator/backups/%d to monitor the status.".formatted(backupId, backupId)), 202);
        }
        catch (Exception e) {
            return this.mapErrorResponse(e);
        }
    }

    @ReadOperation
    public WebEndpointResponse<?> status(@Selector @NonNull long id) {
        try {
            BackupStatus status = (BackupStatus)this.api.getStatus(id).toCompletableFuture().join();
            if (status.status() == State.DOES_NOT_EXIST) {
                return BackupEndpoint.doestNotExistResponse(status.backupId());
            }
            BackupInfo backupInfo = this.getBackupInfoFromBackupStatus(status);
            return new WebEndpointResponse((Object)backupInfo);
        }
        catch (Exception e) {
            return this.mapErrorResponse(e);
        }
    }

    @ReadOperation
    public WebEndpointResponse<?> list() {
        try {
            List backups = (List)this.api.listBackups().toCompletableFuture().join();
            List<BackupInfo> response = backups.stream().map(this::getBackupInfoFromBackupStatus).toList();
            return new WebEndpointResponse(response);
        }
        catch (Exception e) {
            return this.mapErrorResponse(e);
        }
    }

    @DeleteOperation
    public WebEndpointResponse<?> delete(@Selector @NonNull long id) {
        try {
            this.api.deleteBackup(id).toCompletableFuture().join();
            return new WebEndpointResponse(204);
        }
        catch (Exception e) {
            return this.mapErrorResponse(e);
        }
    }

    private BackupInfo getBackupInfoFromBackupStatus(BackupStatus status) {
        BackupInfo backupInfo = new BackupInfo().backupId(status.backupId()).state(this.getBackupStateCode(status.status()));
        status.failureReason().ifPresent(backupInfo::setFailureReason);
        List<PartitionBackupInfo> details = status.partitions().stream().map(this::toPartitionBackupInfo).toList();
        backupInfo.setDetails(details);
        return backupInfo;
    }

    private static WebEndpointResponse<Error> doestNotExistResponse(long backupId) {
        return new WebEndpointResponse((Object)new Error().message("Backup with id %d does not exist".formatted(backupId)), 404);
    }

    private PartitionBackupInfo toPartitionBackupInfo(PartitionBackupStatus partitionStatus) {
        PartitionBackupInfo partitionBackupInfo = new PartitionBackupInfo().partitionId(partitionStatus.partitionId()).state(this.getPartitionBackupStateCode(partitionStatus.status()));
        partitionStatus.failureReason().ifPresent(partitionBackupInfo::setFailureReason);
        partitionStatus.createdAt().ifPresent(time -> {
            Instant i = Instant.parse(time);
            partitionBackupInfo.createdAt(OffsetDateTime.ofInstant(i, ZoneId.of("UTC")));
        });
        partitionStatus.lastUpdatedAt().ifPresent(time -> {
            Instant i = Instant.parse(time);
            partitionBackupInfo.lastUpdatedAt(OffsetDateTime.ofInstant(i, ZoneId.of("UTC")));
        });
        partitionStatus.brokerId().ifPresent(partitionBackupInfo::setBrokerId);
        partitionStatus.brokerVersion().ifPresent(partitionBackupInfo::setBrokerVersion);
        partitionStatus.snapshotId().ifPresent(partitionBackupInfo::setSnapshotId);
        partitionStatus.checkpointPosition().ifPresent(partitionBackupInfo::setCheckpointPosition);
        return partitionBackupInfo;
    }

    private StateCode getBackupStateCode(State state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case State.IN_PROGRESS -> StateCode.IN_PROGRESS;
            case State.COMPLETED -> StateCode.COMPLETED;
            case State.FAILED -> StateCode.FAILED;
            case State.DOES_NOT_EXIST -> StateCode.DOES_NOT_EXIST;
            case State.INCOMPLETE -> StateCode.INCOMPLETE;
        };
    }

    private StateCode getPartitionBackupStateCode(BackupStatusCode status) {
        return switch (status) {
            case BackupStatusCode.IN_PROGRESS -> StateCode.IN_PROGRESS;
            case BackupStatusCode.COMPLETED -> StateCode.COMPLETED;
            case BackupStatusCode.FAILED -> StateCode.FAILED;
            case BackupStatusCode.DOES_NOT_EXIST -> StateCode.DOES_NOT_EXIST;
            default -> throw new IllegalStateException("Unknown BackupState %s".formatted(status));
        };
    }

    private WebEndpointResponse<Error> mapErrorResponse(Throwable exception) {
        Object message;
        int errorCode;
        if (exception instanceof CompletionException) {
            Throwable error = exception.getCause();
            if (error instanceof BackupAlreadyExistException) {
                errorCode = 409;
                message = error.getMessage();
            } else if (error instanceof IncompleteTopologyException) {
                errorCode = 502;
                message = error.getMessage();
            } else if (error instanceof TimeoutException || error instanceof ConnectTimeoutException) {
                errorCode = 504;
                message = "Request from gateway to broker timed out. " + error.getMessage();
            } else if (error instanceof ConnectException) {
                errorCode = 502;
                message = "Failed to send request from gateway to broker." + error.getMessage();
            } else if (error instanceof BrokerErrorException) {
                BrokerErrorException brokerError = (BrokerErrorException)error;
                BrokerError rootError = brokerError.getError();
                errorCode = switch (rootError.getCode()) {
                    case ErrorCode.PARTITION_LEADER_MISMATCH -> 502;
                    case ErrorCode.RESOURCE_EXHAUSTED -> 503;
                    case ErrorCode.UNSUPPORTED_MESSAGE -> 400;
                    default -> 500;
                };
                message = rootError.getMessage();
            } else {
                errorCode = 500;
                message = error.getMessage();
            }
        } else {
            errorCode = 500;
            message = exception.getMessage();
        }
        return new WebEndpointResponse((Object)new Error().message((String)message), errorCode);
    }
}

