/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.shared.management;

import io.atomix.cluster.MemberId;
import io.atomix.cluster.messaging.MessagingException;
import io.atomix.utils.AbstractIdentifier;
import io.camunda.zeebe.management.cluster.BrokerState;
import io.camunda.zeebe.management.cluster.BrokerStateCode;
import io.camunda.zeebe.management.cluster.CompletedChange;
import io.camunda.zeebe.management.cluster.Error;
import io.camunda.zeebe.management.cluster.GetTopologyResponse;
import io.camunda.zeebe.management.cluster.Operation;
import io.camunda.zeebe.management.cluster.PartitionState;
import io.camunda.zeebe.management.cluster.PartitionStateCode;
import io.camunda.zeebe.management.cluster.PlannedOperationsResponse;
import io.camunda.zeebe.management.cluster.TopologyChange;
import io.camunda.zeebe.management.cluster.TopologyChangeCompletedInner;
import io.camunda.zeebe.topology.api.ErrorResponse;
import io.camunda.zeebe.topology.api.TopologyChangeResponse;
import io.camunda.zeebe.topology.api.TopologyManagementRequest;
import io.camunda.zeebe.topology.api.TopologyManagementRequestSender;
import io.camunda.zeebe.topology.state.ClusterChangePlan;
import io.camunda.zeebe.topology.state.ClusterTopology;
import io.camunda.zeebe.topology.state.CompletedChange;
import io.camunda.zeebe.topology.state.MemberState;
import io.camunda.zeebe.topology.state.PartitionState;
import io.camunda.zeebe.topology.state.TopologyChangeOperation;
import io.camunda.zeebe.util.Either;
import java.lang.runtime.SwitchBootstraps;
import java.net.ConnectException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Component
@RestControllerEndpoint(id="cluster")
public class ClusterEndpoint {
    private static final OffsetDateTime MIN_PARSER_COMPLIANT_DATE = OffsetDateTime.parse("0000-01-01T00:00:00Z");
    private final TopologyManagementRequestSender requestSender;

    @Autowired
    public ClusterEndpoint(TopologyManagementRequestSender requestSender) {
        this.requestSender = requestSender;
    }

    @GetMapping(produces={"application/json"})
    public ResponseEntity<?> clusterTopology() {
        try {
            return this.mapClusterTopologyResponse((Either<ErrorResponse, ClusterTopology>)((Either)this.requestSender.getTopology().join()));
        }
        catch (Exception error) {
            return this.mapError(error);
        }
    }

    private ResponseEntity<Error> mapError(Throwable error) {
        if (error instanceof CompletionException) {
            return this.mapError(error.getCause());
        }
        Error errorResponse = new Error();
        errorResponse.setMessage(error.getMessage());
        Throwable throwable = error;
        Objects.requireNonNull(throwable);
        Throwable throwable2 = throwable;
        int n = 0;
        int status = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConnectException.class, MessagingException.NoSuchMemberException.class, TimeoutException.class}, (Object)throwable2, n)) {
            case 0 -> {
                ConnectException ignore = (ConnectException)throwable2;
                yield 502;
            }
            case 1 -> {
                MessagingException.NoSuchMemberException ignore = (MessagingException.NoSuchMemberException)throwable2;
                yield 502;
            }
            case 2 -> {
                TimeoutException ignore = (TimeoutException)throwable2;
                yield 504;
            }
            default -> 500;
        };
        return ResponseEntity.status((int)status).body((Object)errorResponse);
    }

    private ResponseEntity<Error> invalidRequest(String message) {
        Error errorResponse = new Error();
        errorResponse.setMessage(message);
        return ResponseEntity.status((int)400).body((Object)errorResponse);
    }

    @PostMapping(path={"/{resource}/{id}"})
    public ResponseEntity<?> add(@PathVariable(value="resource") Resource resource, @PathVariable int id, @RequestParam(defaultValue="false") boolean dryRun) {
        return switch (resource.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.mapOperationResponse((Either<ErrorResponse, TopologyChangeResponse>)((Either)this.requestSender.addMembers(new TopologyManagementRequest.AddMembersRequest(Set.of(new MemberId(String.valueOf(id))), dryRun)).join()));
            case 1 -> ResponseEntity.status((int)501).body((Object)"Adding partitions is not supported");
            case 2 -> ResponseEntity.status((int)501).body((Object)"Changing cluster directly is not supported. Use POST /cluster/brokers for scaling the cluster");
        };
    }

    @DeleteMapping(path={"/{resource}/{id}"})
    public ResponseEntity<?> remove(@PathVariable(value="resource") Resource resource, @PathVariable String id, @RequestParam(defaultValue="false") boolean dryRun) {
        return switch (resource.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.mapOperationResponse((Either<ErrorResponse, TopologyChangeResponse>)((Either)this.requestSender.removeMembers(new TopologyManagementRequest.RemoveMembersRequest(Set.of(new MemberId(id)), dryRun)).join()));
            case 1 -> ResponseEntity.status((int)501).body((Object)"Removing partitions is not supported");
            case 2 -> dryRun ? ResponseEntity.status((int)501).body((Object)"Dry run is not supported for cancelling changes") : this.cancelChange(id);
        };
    }

    private ResponseEntity<?> cancelChange(String changeId) {
        try {
            return this.mapClusterTopologyResponse((Either<ErrorResponse, ClusterTopology>)((Either)this.requestSender.cancelTopologyChange(new TopologyManagementRequest.CancelChangeRequest(Long.parseLong(changeId))).join()));
        }
        catch (NumberFormatException ignore) {
            return this.invalidRequest("Change id must be a number");
        }
        catch (Exception error) {
            return this.mapError(error);
        }
    }

    @PostMapping(path={"/{resource}"}, consumes={"application/json"})
    public ResponseEntity<?> scale(@PathVariable(value="resource") Resource resource, @RequestBody List<Integer> ids, @RequestParam(defaultValue="false") boolean dryRun, @RequestParam(defaultValue="false") boolean force, @RequestParam Optional<Integer> replicationFactor) {
        return switch (resource.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.scaleBrokers(ids, dryRun, force, replicationFactor);
            case 1 -> new ResponseEntity((Object)"Scaling partitions is not supported", HttpStatusCode.valueOf((int)501));
            case 2 -> ResponseEntity.status((int)501).body((Object)"Changing cluster directly is not supported. Use POST /cluster/brokers for scaling the cluster");
        };
    }

    private ResponseEntity<?> scaleBrokers(List<Integer> ids, boolean dryRun, boolean force, Optional<Integer> replicationFactor) {
        try {
            TopologyManagementRequest.ScaleRequest scaleRequest = new TopologyManagementRequest.ScaleRequest(ids.stream().map(String::valueOf).map(MemberId::from).collect(Collectors.toSet()), replicationFactor, dryRun);
            Either response = force ? (Either)this.requestSender.forceScaleDown(scaleRequest).join() : (Either)this.requestSender.scaleMembers(scaleRequest).join();
            return this.mapOperationResponse((Either<ErrorResponse, TopologyChangeResponse>)response);
        }
        catch (Exception error) {
            return this.mapError(error);
        }
    }

    @PostMapping(path={"/{resource}/{resourceId}/{subResource}/{subResourceId}"}, consumes={"application/json"})
    public ResponseEntity<?> addSubResource(@PathVariable(value="resource") Resource resource, @PathVariable int resourceId, @PathVariable(value="subResource") Resource subResource, @PathVariable int subResourceId, @RequestBody PartitionAddRequest request, @RequestParam(defaultValue="false") boolean dryRun) {
        int priority = request.priority();
        return switch (resource.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                switch (subResource.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 1: {
                        yield this.mapOperationResponse((Either<ErrorResponse, TopologyChangeResponse>)((Either)this.requestSender.joinPartition(new TopologyManagementRequest.JoinPartitionRequest(MemberId.from((String)String.valueOf(resourceId)), subResourceId, priority, dryRun)).join()));
                    }
                    case 0: 
                    case 2: 
                }
                yield new ResponseEntity(HttpStatusCode.valueOf((int)404));
            }
            case 1 -> {
                switch (subResource.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield this.mapOperationResponse((Either<ErrorResponse, TopologyChangeResponse>)((Either)this.requestSender.joinPartition(new TopologyManagementRequest.JoinPartitionRequest(MemberId.from((String)String.valueOf(subResourceId)), resourceId, priority, dryRun)).join()));
                    }
                    case 1: 
                    case 2: 
                }
                yield new ResponseEntity(HttpStatusCode.valueOf((int)404));
            }
            case 2 -> new ResponseEntity(HttpStatusCode.valueOf((int)404));
        };
    }

    @DeleteMapping(path={"/{resource}/{resourceId}/{subResource}/{subResourceId}"}, consumes={"application/json"})
    public ResponseEntity<?> removeSubResource(@PathVariable(value="resource") Resource resource, @PathVariable int resourceId, @PathVariable(value="subResource") Resource subResource, @PathVariable int subResourceId, @RequestParam(defaultValue="false") boolean dryRun) {
        return switch (resource.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                switch (subResource.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 1: {
                        yield this.mapOperationResponse((Either<ErrorResponse, TopologyChangeResponse>)((Either)this.requestSender.leavePartition(new TopologyManagementRequest.LeavePartitionRequest(MemberId.from((String)String.valueOf(resourceId)), subResourceId, dryRun)).join()));
                    }
                    case 0: 
                    case 2: 
                }
                yield new ResponseEntity(HttpStatusCode.valueOf((int)404));
            }
            case 1 -> {
                switch (subResource.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield this.mapOperationResponse((Either<ErrorResponse, TopologyChangeResponse>)((Either)this.requestSender.leavePartition(new TopologyManagementRequest.LeavePartitionRequest(MemberId.from((String)String.valueOf(subResourceId)), resourceId, dryRun)).join()));
                    }
                    case 1: 
                    case 2: 
                }
                yield new ResponseEntity(HttpStatusCode.valueOf((int)404));
            }
            case 2 -> new ResponseEntity(HttpStatusCode.valueOf((int)404));
        };
    }

    private ResponseEntity<?> mapOperationResponse(Either<ErrorResponse, TopologyChangeResponse> response) {
        if (response.isRight()) {
            return ResponseEntity.status((int)202).body((Object)ClusterEndpoint.mapResponseType((TopologyChangeResponse)response.get()));
        }
        return this.mapErrorResponse((ErrorResponse)response.getLeft());
    }

    private ResponseEntity<?> mapClusterTopologyResponse(Either<ErrorResponse, ClusterTopology> response) {
        if (response.isRight()) {
            return ResponseEntity.status((int)200).body((Object)ClusterEndpoint.mapClusterTopology((ClusterTopology)response.get()));
        }
        return this.mapErrorResponse((ErrorResponse)response.getLeft());
    }

    private ResponseEntity<Error> mapErrorResponse(ErrorResponse response) {
        int errorCode = switch (response.code()) {
            default -> throw new MatchException(null, null);
            case ErrorResponse.ErrorCode.INVALID_REQUEST, ErrorResponse.ErrorCode.OPERATION_NOT_ALLOWED -> 400;
            case ErrorResponse.ErrorCode.CONCURRENT_MODIFICATION -> 409;
            case ErrorResponse.ErrorCode.INTERNAL_ERROR -> 500;
        };
        Error error = new Error();
        error.setMessage(response.message());
        return ResponseEntity.status((int)errorCode).body((Object)error);
    }

    private static PlannedOperationsResponse mapResponseType(TopologyChangeResponse response) {
        return new PlannedOperationsResponse().changeId(response.changeId()).currentTopology(ClusterEndpoint.mapBrokerStates(response.currentTopology())).expectedTopology(ClusterEndpoint.mapBrokerStates(response.expectedTopology())).plannedChanges(ClusterEndpoint.mapOperations(response.plannedChanges()));
    }

    private static List<Operation> mapOperations(List<TopologyChangeOperation> operations) {
        return operations.stream().map(ClusterEndpoint::mapOperation).toList();
    }

    private static Operation mapOperation(TopologyChangeOperation operation) {
        TopologyChangeOperation topologyChangeOperation = operation;
        Objects.requireNonNull(topologyChangeOperation);
        TopologyChangeOperation topologyChangeOperation2 = topologyChangeOperation;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TopologyChangeOperation.MemberJoinOperation.class, TopologyChangeOperation.MemberLeaveOperation.class, TopologyChangeOperation.PartitionChangeOperation.PartitionJoinOperation.class, TopologyChangeOperation.PartitionChangeOperation.PartitionLeaveOperation.class, TopologyChangeOperation.PartitionChangeOperation.PartitionReconfigurePriorityOperation.class, TopologyChangeOperation.PartitionChangeOperation.PartitionForceReconfigureOperation.class, TopologyChangeOperation.MemberRemoveOperation.class}, (Object)topologyChangeOperation2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                TopologyChangeOperation.MemberJoinOperation join = (TopologyChangeOperation.MemberJoinOperation)topologyChangeOperation2;
                yield new Operation().operation(Operation.OperationEnum.BROKER_ADD).brokerId(Integer.parseInt((String)((Object)join.memberId().id())));
            }
            case 1 -> {
                TopologyChangeOperation.MemberLeaveOperation leave = (TopologyChangeOperation.MemberLeaveOperation)topologyChangeOperation2;
                yield new Operation().operation(Operation.OperationEnum.BROKER_REMOVE).brokerId(Integer.parseInt((String)((Object)leave.memberId().id())));
            }
            case 2 -> {
                TopologyChangeOperation.PartitionChangeOperation.PartitionJoinOperation join = (TopologyChangeOperation.PartitionChangeOperation.PartitionJoinOperation)topologyChangeOperation2;
                yield new Operation().operation(Operation.OperationEnum.PARTITION_JOIN).brokerId(Integer.parseInt((String)((Object)join.memberId().id()))).partitionId(join.partitionId()).priority(join.priority());
            }
            case 3 -> {
                TopologyChangeOperation.PartitionChangeOperation.PartitionLeaveOperation leave = (TopologyChangeOperation.PartitionChangeOperation.PartitionLeaveOperation)topologyChangeOperation2;
                yield new Operation().operation(Operation.OperationEnum.PARTITION_LEAVE).brokerId(Integer.parseInt((String)((Object)leave.memberId().id()))).partitionId(leave.partitionId());
            }
            case 4 -> {
                TopologyChangeOperation.PartitionChangeOperation.PartitionReconfigurePriorityOperation reconfigure = (TopologyChangeOperation.PartitionChangeOperation.PartitionReconfigurePriorityOperation)topologyChangeOperation2;
                yield new Operation().operation(Operation.OperationEnum.PARTITION_RECONFIGURE_PRIORITY).brokerId(Integer.parseInt((String)((Object)reconfigure.memberId().id()))).partitionId(reconfigure.partitionId()).priority(reconfigure.priority());
            }
            case 5 -> {
                TopologyChangeOperation.PartitionChangeOperation.PartitionForceReconfigureOperation partitionForceReconfigureOperation = (TopologyChangeOperation.PartitionChangeOperation.PartitionForceReconfigureOperation)topologyChangeOperation2;
                yield new Operation().operation(Operation.OperationEnum.PARTITION_FORCE_RECONFIGURE).brokerId(Integer.parseInt((String)((Object)partitionForceReconfigureOperation.memberId().id()))).partitionId(partitionForceReconfigureOperation.partitionId()).brokers(partitionForceReconfigureOperation.members().stream().map(AbstractIdentifier::id).map(Integer::parseInt).collect(Collectors.toList()));
            }
            case 6 -> {
                TopologyChangeOperation.MemberRemoveOperation memberRemoveOperation = (TopologyChangeOperation.MemberRemoveOperation)topologyChangeOperation2;
                yield new Operation().operation(Operation.OperationEnum.BROKER_REMOVE).brokerId(Integer.parseInt((String)((Object)memberRemoveOperation.memberId().id()))).brokers(List.of(Integer.valueOf(Integer.parseInt((String)((Object)memberRemoveOperation.memberToRemove().id())))));
            }
        };
    }

    private static List<BrokerState> mapBrokerStates(Map<MemberId, MemberState> topology) {
        return topology.entrySet().stream().map(entry -> new BrokerState().id(Integer.parseInt((String)((Object)((MemberId)entry.getKey()).id()))).state(ClusterEndpoint.mapBrokerState(((MemberState)entry.getValue()).state())).lastUpdatedAt(ClusterEndpoint.mapInstantToDateTime(((MemberState)entry.getValue()).lastUpdated())).version(((MemberState)entry.getValue()).version()).partitions(ClusterEndpoint.mapPartitionStates(((MemberState)entry.getValue()).partitions()))).toList();
    }

    private static OffsetDateTime mapInstantToDateTime(Instant timestamp) {
        return timestamp.equals(Instant.MIN) ? MIN_PARSER_COMPLIANT_DATE : timestamp.atOffset(ZoneOffset.UTC);
    }

    private static BrokerStateCode mapBrokerState(MemberState.State state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case MemberState.State.ACTIVE -> BrokerStateCode.ACTIVE;
            case MemberState.State.JOINING -> BrokerStateCode.JOINING;
            case MemberState.State.LEAVING -> BrokerStateCode.LEAVING;
            case MemberState.State.LEFT -> BrokerStateCode.LEFT;
            case MemberState.State.UNINITIALIZED -> BrokerStateCode.UNKNOWN;
        };
    }

    private static List<PartitionState> mapPartitionStates(Map<Integer, io.camunda.zeebe.topology.state.PartitionState> partitions) {
        return partitions.entrySet().stream().map(entry -> new PartitionState().id((Integer)entry.getKey()).priority(((io.camunda.zeebe.topology.state.PartitionState)entry.getValue()).priority()).state(ClusterEndpoint.mapPartitionState(((io.camunda.zeebe.topology.state.PartitionState)entry.getValue()).state()))).toList();
    }

    private static PartitionStateCode mapPartitionState(PartitionState.State state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case PartitionState.State.JOINING -> PartitionStateCode.JOINING;
            case PartitionState.State.ACTIVE -> PartitionStateCode.ACTIVE;
            case PartitionState.State.LEAVING -> PartitionStateCode.LEAVING;
            case PartitionState.State.UNKNOWN -> PartitionStateCode.UNKNOWN;
        };
    }

    private static GetTopologyResponse mapClusterTopology(ClusterTopology topology) {
        GetTopologyResponse response = new GetTopologyResponse();
        List<BrokerState> brokers = ClusterEndpoint.mapBrokerStates(topology.members());
        response.version(topology.version()).brokers(brokers);
        topology.lastChange().ifPresent(change -> response.lastChange(ClusterEndpoint.mapCompletedChange(change)));
        topology.pendingChanges().ifPresent(change -> response.pendingChange(ClusterEndpoint.mapOngoingChange(change)));
        return response;
    }

    private static io.camunda.zeebe.management.cluster.CompletedChange mapCompletedChange(CompletedChange completedChange) {
        return new io.camunda.zeebe.management.cluster.CompletedChange().id(completedChange.id()).status(ClusterEndpoint.mapCompletedChangeStatus(completedChange.status())).startedAt(ClusterEndpoint.mapInstantToDateTime(completedChange.startedAt())).completedAt(ClusterEndpoint.mapInstantToDateTime(completedChange.completedAt()));
    }

    private static TopologyChange mapOngoingChange(ClusterChangePlan clusterChangePlan) {
        return new TopologyChange().id(clusterChangePlan.id()).status(ClusterEndpoint.mapChangeStatus(clusterChangePlan.status())).pending(ClusterEndpoint.mapOperations(clusterChangePlan.pendingOperations())).completed(ClusterEndpoint.mapCompletedOperations(clusterChangePlan.completedOperations()));
    }

    private static CompletedChange.StatusEnum mapCompletedChangeStatus(ClusterChangePlan.Status status) {
        return switch (status) {
            default -> throw new MatchException(null, null);
            case ClusterChangePlan.Status.COMPLETED -> CompletedChange.StatusEnum.COMPLETED;
            case ClusterChangePlan.Status.FAILED -> CompletedChange.StatusEnum.FAILED;
            case ClusterChangePlan.Status.CANCELLED -> CompletedChange.StatusEnum.CANCELLED;
            case ClusterChangePlan.Status.IN_PROGRESS -> throw new IllegalStateException("Completed change cannot be in progress");
        };
    }

    private static TopologyChange.StatusEnum mapChangeStatus(ClusterChangePlan.Status status) {
        return switch (status) {
            default -> throw new MatchException(null, null);
            case ClusterChangePlan.Status.IN_PROGRESS -> TopologyChange.StatusEnum.IN_PROGRESS;
            case ClusterChangePlan.Status.COMPLETED -> TopologyChange.StatusEnum.COMPLETED;
            case ClusterChangePlan.Status.FAILED -> TopologyChange.StatusEnum.FAILED;
            case ClusterChangePlan.Status.CANCELLED -> TopologyChange.StatusEnum.CANCELLED;
        };
    }

    private static List<TopologyChangeCompletedInner> mapCompletedOperations(List<ClusterChangePlan.CompletedOperation> completedOperations) {
        return completedOperations.stream().map(ClusterEndpoint::mapCompletedOperation).toList();
    }

    private static TopologyChangeCompletedInner mapCompletedOperation(ClusterChangePlan.CompletedOperation operation) {
        TopologyChangeOperation topologyChangeOperation = operation.operation();
        Objects.requireNonNull(topologyChangeOperation);
        TopologyChangeOperation topologyChangeOperation2 = topologyChangeOperation;
        int n = 0;
        TopologyChangeCompletedInner mappedOperation = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TopologyChangeOperation.MemberJoinOperation.class, TopologyChangeOperation.MemberLeaveOperation.class, TopologyChangeOperation.PartitionChangeOperation.PartitionJoinOperation.class, TopologyChangeOperation.PartitionChangeOperation.PartitionLeaveOperation.class, TopologyChangeOperation.PartitionChangeOperation.PartitionReconfigurePriorityOperation.class, TopologyChangeOperation.PartitionChangeOperation.PartitionForceReconfigureOperation.class, TopologyChangeOperation.MemberRemoveOperation.class}, (Object)topologyChangeOperation2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                TopologyChangeOperation.MemberJoinOperation join = (TopologyChangeOperation.MemberJoinOperation)topologyChangeOperation2;
                yield new TopologyChangeCompletedInner().operation(TopologyChangeCompletedInner.OperationEnum.BROKER_ADD).brokerId(Integer.parseInt((String)((Object)join.memberId().id())));
            }
            case 1 -> {
                TopologyChangeOperation.MemberLeaveOperation leave = (TopologyChangeOperation.MemberLeaveOperation)topologyChangeOperation2;
                yield new TopologyChangeCompletedInner().operation(TopologyChangeCompletedInner.OperationEnum.BROKER_REMOVE).brokerId(Integer.parseInt((String)((Object)leave.memberId().id())));
            }
            case 2 -> {
                TopologyChangeOperation.PartitionChangeOperation.PartitionJoinOperation join = (TopologyChangeOperation.PartitionChangeOperation.PartitionJoinOperation)topologyChangeOperation2;
                yield new TopologyChangeCompletedInner().operation(TopologyChangeCompletedInner.OperationEnum.PARTITION_JOIN).brokerId(Integer.parseInt((String)((Object)join.memberId().id()))).partitionId(join.partitionId()).priority(join.priority());
            }
            case 3 -> {
                TopologyChangeOperation.PartitionChangeOperation.PartitionLeaveOperation leave = (TopologyChangeOperation.PartitionChangeOperation.PartitionLeaveOperation)topologyChangeOperation2;
                yield new TopologyChangeCompletedInner().operation(TopologyChangeCompletedInner.OperationEnum.PARTITION_LEAVE).brokerId(Integer.parseInt((String)((Object)leave.memberId().id()))).partitionId(leave.partitionId());
            }
            case 4 -> {
                TopologyChangeOperation.PartitionChangeOperation.PartitionReconfigurePriorityOperation reconfigure = (TopologyChangeOperation.PartitionChangeOperation.PartitionReconfigurePriorityOperation)topologyChangeOperation2;
                yield new TopologyChangeCompletedInner().operation(TopologyChangeCompletedInner.OperationEnum.PARTITION_RECONFIGURE_PRIORITY).brokerId(Integer.parseInt((String)((Object)reconfigure.memberId().id()))).partitionId(reconfigure.partitionId()).priority(reconfigure.priority());
            }
            case 5 -> {
                TopologyChangeOperation.PartitionChangeOperation.PartitionForceReconfigureOperation partitionForceReconfigureOperation = (TopologyChangeOperation.PartitionChangeOperation.PartitionForceReconfigureOperation)topologyChangeOperation2;
                yield new TopologyChangeCompletedInner().operation(TopologyChangeCompletedInner.OperationEnum.PARTITION_FORCE_RECONFIGURE).brokerId(Integer.parseInt((String)((Object)partitionForceReconfigureOperation.memberId().id()))).partitionId(partitionForceReconfigureOperation.partitionId()).brokers(partitionForceReconfigureOperation.members().stream().map(AbstractIdentifier::id).map(Integer::parseInt).collect(Collectors.toList()));
            }
            case 6 -> {
                TopologyChangeOperation.MemberRemoveOperation memberRemoveOperation = (TopologyChangeOperation.MemberRemoveOperation)topologyChangeOperation2;
                yield new TopologyChangeCompletedInner().operation(TopologyChangeCompletedInner.OperationEnum.BROKER_REMOVE).brokerId(Integer.parseInt((String)((Object)memberRemoveOperation.memberId().id()))).brokers(List.of(Integer.valueOf(Integer.parseInt((String)((Object)memberRemoveOperation.memberToRemove().id())))));
            }
        };
        mappedOperation.completedAt(ClusterEndpoint.mapInstantToDateTime(operation.completedAt()));
        return mappedOperation;
    }

    public static enum Resource {
        brokers,
        partitions,
        changes;

    }

    public record PartitionAddRequest(int priority) {
    }
}

