/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.shared.management;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
@Documented
@Conditional(value={OnManagementContextCondition.class})
public @interface ConditionalOnManagementContext {

    public static final class OnManagementContextCondition
    extends SpringBootCondition {
        static final String MANAGEMENT_ONLY_BEAN_NAME = "ManagementContextWebServerFactory";

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ManagementPortType managementPortType = ManagementPortType.get((Environment)context.getEnvironment());
            return switch (managementPortType) {
                default -> throw new MatchException(null, null);
                case ManagementPortType.DISABLED -> ConditionOutcome.noMatch((String)"no management application defined");
                case ManagementPortType.SAME -> ConditionOutcome.match();
                case ManagementPortType.DIFFERENT -> context.getRegistry().containsBeanDefinition(MANAGEMENT_ONLY_BEAN_NAME) ? ConditionOutcome.match() : ConditionOutcome.noMatch((String)"not the management context");
            };
        }
    }
}

