/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.shared.management;

import io.camunda.zeebe.gateway.admin.exporting.ExportingControlApi;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Component
@RestControllerEndpoint(id="exporting")
public final class ExportingEndpoint {
    static final String PAUSE = "pause";
    static final String RESUME = "resume";
    final ExportingControlApi exportingService;

    @Autowired
    public ExportingEndpoint(ExportingControlApi exportingService) {
        this.exportingService = exportingService;
    }

    @PostMapping(path={"/{operationKey}"})
    public WebEndpointResponse<?> post(@PathVariable(value="operationKey") String operationKey, @RequestParam(defaultValue="false") boolean soft) {
        try {
            boolean softPause = soft;
            CompletableFuture result = switch (operationKey) {
                case RESUME -> this.exportingService.resumeExporting();
                case PAUSE -> {
                    if (softPause) {
                        yield this.exportingService.softPauseExporting();
                    }
                    yield this.exportingService.pauseExporting();
                }
                default -> throw new UnsupportedOperationException();
            };
            result.join();
            return new WebEndpointResponse(204);
        }
        catch (CompletionException e) {
            return new WebEndpointResponse((Object)e.getCause(), 500);
        }
        catch (Exception e) {
            return new WebEndpointResponse((Object)e, 500);
        }
    }
}

