/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.shared.management;

import io.atomix.utils.AbstractIdentifier;
import io.camunda.zeebe.protocol.impl.stream.job.JobActivationProperties;
import io.camunda.zeebe.transport.stream.api.ClientStream;
import io.camunda.zeebe.transport.stream.api.RemoteStreamInfo;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.agrona.DirectBuffer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpoint;
import org.springframework.stereotype.Component;
import org.springframework.util.MimeTypeUtils;

@Component
@WebEndpoint(id="jobstreams")
public final class JobStreamEndpoint {
    private static final Set<String> TYPES = Set.of("remote", "client");
    private final Service service;

    @Autowired
    public JobStreamEndpoint(Service service) {
        this.service = Objects.requireNonNull(service, "must specify a job stream service");
    }

    @ReadOperation
    public WebEndpointResponse<JobStreams> list() {
        return new WebEndpointResponse((Object)new JobStreams(this.getRemoteStreams(), this.getClientStreams()), 200, MimeTypeUtils.APPLICATION_JSON);
    }

    @ReadOperation
    public WebEndpointResponse<?> list(@Selector String type) {
        if (!TYPES.contains(type)) {
            return new WebEndpointResponse(Map.of("error", "No known stream type '%s'; should be one of %s".formatted(type, TYPES)), 400, MimeTypeUtils.APPLICATION_JSON);
        }
        Collection<Record> streams = "client".equals(type) ? this.getClientStreams() : this.getRemoteStreams();
        return new WebEndpointResponse(streams, 200, MimeTypeUtils.APPLICATION_JSON);
    }

    private Collection<RemoteJobStream> getRemoteStreams() {
        return this.transformRemote(this.service.remoteJobStreams());
    }

    private Collection<ClientJobStream> getClientStreams() {
        return this.transformClient(this.service.clientJobStreams());
    }

    private Collection<RemoteJobStream> transformRemote(Collection<RemoteStreamInfo<JobActivationProperties>> streams) {
        return streams.stream().map(this::transformRemote).toList();
    }

    private Collection<ClientJobStream> transformClient(Collection<ClientStream<JobActivationProperties>> streams) {
        return streams.stream().map(this::transformClient).toList();
    }

    private RemoteJobStream transformRemote(RemoteStreamInfo<JobActivationProperties> stream) {
        List<RemoteStreamId> consumers = stream.consumers().stream().map(id -> new RemoteStreamId(id.streamId(), (String)((Object)id.receiver().id()))).toList();
        return new RemoteJobStream(BufferUtil.bufferAsString((DirectBuffer)stream.streamType()), this.transform((JobActivationProperties)stream.metadata()), consumers);
    }

    private ClientJobStream transformClient(ClientStream<JobActivationProperties> stream) {
        List<Integer> brokers = stream.liveConnections().stream().map(AbstractIdentifier::id).map(Integer::valueOf).toList();
        return new ClientJobStream(BufferUtil.bufferAsString((DirectBuffer)stream.streamType()), stream.streamId(), this.transform((JobActivationProperties)stream.metadata()), brokers);
    }

    private Metadata transform(JobActivationProperties properties) {
        return new Metadata(BufferUtil.bufferAsString((DirectBuffer)properties.worker()), Duration.ofMillis(properties.timeout()), properties.fetchVariables().stream().map(BufferUtil::bufferAsString).toList(), properties.tenantIds());
    }

    public static interface Service {
        public Collection<RemoteStreamInfo<JobActivationProperties>> remoteJobStreams();

        public Collection<ClientStream<JobActivationProperties>> clientJobStreams();
    }

    public record JobStreams(Collection<RemoteJobStream> remote, Collection<ClientJobStream> client) {
    }

    public record RemoteJobStream(String jobType, Metadata metadata, Collection<RemoteStreamId> consumers) implements JobStream
    {
    }

    public record Metadata(String worker, Duration timeout, Collection<String> fetchVariables, Collection<String> tenantIds) {
    }

    public record ClientJobStream(String jobType, Object id, Metadata metadata, Collection<Integer> connectedTo) implements JobStream
    {
    }

    public record RemoteStreamId(UUID id, String receiver) {
    }

    public static interface JobStream {
        public Metadata metadata();

        public String jobType();
    }
}

