/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.shared.security;

import io.camunda.identity.sdk.authentication.AccessToken;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public record IdentityAuthentication(AccessToken token, List<String> tenantIds) implements Authentication
{
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return Collections.emptyList();
    }

    public Object getCredentials() {
        return this.token.getToken();
    }

    public Object getDetails() {
        return this.token.getUserDetails();
    }

    public Object getPrincipal() {
        return this.token;
    }

    public boolean isAuthenticated() {
        return true;
    }

    public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
        if (!isAuthenticated) {
            throw new UnsupportedOperationException("Expected to mark Identity token as unauthenticated, but it always is");
        }
    }

    public String getName() {
        return this.token.getUserDetails().getName().orElse(this.token.getUserDetails().getId());
    }
}

