/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.shared.security;

import io.camunda.identity.sdk.Identity;
import io.camunda.identity.sdk.authentication.AccessToken;
import io.camunda.identity.sdk.tenants.dto.Tenant;
import io.camunda.zeebe.gateway.impl.configuration.ExperimentalCfg;
import io.camunda.zeebe.gateway.impl.configuration.MultiTenancyCfg;
import io.camunda.zeebe.gateway.impl.identity.IdentityTenantService;
import io.camunda.zeebe.shared.security.IdentityAuthentication;
import io.camunda.zeebe.shared.security.PreAuthToken;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public final class IdentityAuthenticationManager
implements ReactiveAuthenticationManager {
    private final Identity identity;
    private final IdentityTenantService tenantService;
    private final MultiTenancyCfg multiTenancy;

    @Autowired
    public IdentityAuthenticationManager(Identity identity, MultiTenancyCfg multiTenancy, ExperimentalCfg experimentalCfg) {
        this.identity = identity;
        this.multiTenancy = multiTenancy;
        this.tenantService = new IdentityTenantService(identity, experimentalCfg.getIdentityRequest());
    }

    public Mono<Authentication> authenticate(Authentication authentication) {
        AccessToken token;
        if (!(authentication instanceof PreAuthToken)) {
            return Mono.just((Object)authentication);
        }
        PreAuthToken preAuthToken = (PreAuthToken)authentication;
        String tokenValue = preAuthToken.token();
        try {
            token = this.identity.authentication().verifyToken(tokenValue);
        }
        catch (Exception e) {
            throw new BadCredentialsException(e.getMessage(), (Throwable)e);
        }
        List<String> tenants = this.getTenants(tokenValue);
        return Mono.just((Object)new IdentityAuthentication(token, tenants));
    }

    private List<String> getTenants(String token) {
        if (!this.multiTenancy.isEnabled()) {
            return Collections.singletonList("<default>");
        }
        try {
            return this.tenantService.getTenantsForToken(token).stream().map(Tenant::getTenantId).toList();
        }
        catch (RuntimeException | ExecutionException e) {
            throw new InternalAuthenticationServiceException("Expected Identity to provide authorized tenants, see cause for details", (Throwable)e);
        }
    }
}

