/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.shared.security;

import io.camunda.zeebe.shared.security.PreAuthToken;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.http.HttpHeaders;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.server.authentication.ServerAuthenticationConverter;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component
public final class PreAuthTokenConverter
implements ServerAuthenticationConverter {
    private static final NoToken EMPTY_TOKEN = new NoToken();

    public Mono<Authentication> convert(ServerWebExchange exchange) {
        return Mono.just((Object)this.getTokenFromHeader(exchange.getRequest().getHeaders()).map(PreAuthToken::new).orElse((Authentication)EMPTY_TOKEN));
    }

    private Optional<String> getTokenFromHeader(HttpHeaders headers) {
        List values = headers.getOrEmpty((Object)"Authorization");
        if (values.isEmpty()) {
            return Optional.empty();
        }
        String token = ((String)values.get(0)).strip().replaceFirst("^Bearer ", "");
        return token.isBlank() ? Optional.empty() : Optional.of(token);
    }

    private static final class NoToken
    extends AbstractAuthenticationToken {
        private final NoCredentials credentials = new NoCredentials();
        private final NoPrincipal principal = new NoPrincipal();

        public NoToken() {
            super(Collections.emptyList());
        }

        public Object getCredentials() {
            return this.credentials;
        }

        public Object getPrincipal() {
            return this.principal;
        }

        public String getName() {
            return "NoToken";
        }

        public boolean isAuthenticated() {
            return false;
        }

        public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
            if (isAuthenticated) {
                throw new UnsupportedOperationException("Cannot authenticate an empty token authentication");
            }
        }

        private record NoCredentials() {
        }

        private record NoPrincipal() {
        }
    }
}

