/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.shared.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ProblemDetail;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.ServerAuthenticationFailureHandler;
import org.springframework.security.web.server.authorization.ServerAccessDeniedHandler;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component
public final class ProblemAuthFailureHandler
implements ServerAuthenticationFailureHandler,
ServerAccessDeniedHandler,
ServerAuthenticationEntryPoint {
    private final ObjectMapper objectMapper;

    @Autowired
    public ProblemAuthFailureHandler(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Mono<Void> onAuthenticationFailure(WebFilterExchange exchange, AuthenticationException error) {
        return this.handleFailure(exchange.getExchange(), HttpStatus.UNAUTHORIZED, (Exception)error);
    }

    public Mono<Void> handle(ServerWebExchange exchange, AccessDeniedException error) {
        return exchange.getPrincipal().flatMap(principal -> {
            Authentication auth;
            if (principal instanceof Authentication && (auth = (Authentication)principal).isAuthenticated()) {
                return this.handleFailure(exchange, HttpStatus.FORBIDDEN, (Exception)error);
            }
            return this.handleFailure(exchange, HttpStatus.UNAUTHORIZED, (Exception)error);
        });
    }

    public Mono<Void> commence(ServerWebExchange exchange, AuthenticationException error) {
        return this.handleFailure(exchange, HttpStatus.UNAUTHORIZED, (Exception)error);
    }

    private Mono<Void> handleFailure(ServerWebExchange exchange, HttpStatus status, Exception error) {
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpResponse response = exchange.getResponse();
        ProblemDetail problem = ProblemDetail.forStatus((HttpStatusCode)status);
        problem.setInstance(request.getURI());
        problem.setDetail(error.getMessage());
        response.setStatusCode((HttpStatusCode)status);
        response.getHeaders().setContentType(MediaType.APPLICATION_PROBLEM_JSON);
        return response.writeWith((Publisher)Mono.fromCallable(() -> this.objectMapper.writeValueAsBytes((Object)problem)).map(bytes -> response.bufferFactory().wrap(bytes)));
    }
}

