/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.shared.security;

import io.camunda.zeebe.gateway.rest.ConditionalOnRestGatewayEnabled;
import io.camunda.zeebe.gateway.rest.TenantAttributeHolder;
import io.camunda.zeebe.shared.management.ConditionalOnManagementContext;
import io.camunda.zeebe.shared.security.IdentityAuthentication;
import io.camunda.zeebe.shared.security.IdentityAuthenticationManager;
import io.camunda.zeebe.shared.security.PreAuthTokenConverter;
import io.camunda.zeebe.shared.security.ProblemAuthFailureHandler;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextType;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.NoneNestedConditions;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Profile;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.config.annotation.method.configuration.EnableReactiveMethodSecurity;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.SecurityWebFiltersOrder;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.AuthenticationWebFilter;
import org.springframework.security.web.server.authentication.ServerAuthenticationConverter;
import org.springframework.security.web.server.authentication.ServerAuthenticationFailureHandler;
import org.springframework.security.web.server.authorization.ServerAccessDeniedHandler;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import reactor.core.publisher.Mono;

@Profile(value={"identity-auth"})
@EnableWebFluxSecurity
@EnableReactiveMethodSecurity
@Configuration(proxyBeanMethods=false)
@Conditional(value={GatewaySecurityAuthenticationEnabledCondition.class})
public final class SecurityConfiguration {
    @Bean
    @ConditionalOnRestGatewayEnabled
    public SecurityWebFilterChain restGatewaySecurity(ServerHttpSecurity http, IdentityAuthenticationManager authManager, PreAuthTokenConverter converter, ProblemAuthFailureHandler authFailureHandler) {
        AuthenticationWebFilter authFilter = new AuthenticationWebFilter((ReactiveAuthenticationManager)authManager);
        authFilter.setServerAuthenticationConverter((ServerAuthenticationConverter)converter);
        authFilter.setAuthenticationFailureHandler((ServerAuthenticationFailureHandler)authFailureHandler);
        authFilter.setAuthenticationSuccessHandler(SecurityConfiguration::injectTenantIds);
        return SecurityConfiguration.configureSecurity(http).authenticationManager((ReactiveAuthenticationManager)authManager).addFilterAt((WebFilter)authFilter, SecurityWebFiltersOrder.AUTHENTICATION).exceptionHandling(spec -> spec.authenticationEntryPoint((ServerAuthenticationEntryPoint)authFailureHandler).accessDeniedHandler((ServerAccessDeniedHandler)authFailureHandler)).authorizeExchange(spec -> spec.anyExchange().authenticated()).build();
    }

    private static Mono<Void> injectTenantIds(WebFilterExchange webFilterExchange, Authentication authentication) {
        ServerWebExchange exchange = webFilterExchange.getExchange();
        if (authentication instanceof IdentityAuthentication) {
            IdentityAuthentication identity = (IdentityAuthentication)authentication;
            TenantAttributeHolder.withTenantIds((ServerWebExchange)exchange, identity.tenantIds());
        }
        return webFilterExchange.getChain().filter(exchange);
    }

    private static ServerHttpSecurity configureSecurity(ServerHttpSecurity http) {
        return http.csrf(ServerHttpSecurity.CsrfSpec::disable).cors(ServerHttpSecurity.CorsSpec::disable).logout(ServerHttpSecurity.LogoutSpec::disable).formLogin(ServerHttpSecurity.FormLoginSpec::disable).httpBasic(ServerHttpSecurity.HttpBasicSpec::disable).anonymous(ServerHttpSecurity.AnonymousSpec::disable);
    }

    static class GatewaySecurityAuthenticationEnabledCondition
    extends NoneNestedConditions {
        public GatewaySecurityAuthenticationEnabledCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="zeebe.broker.gateway", value={"security.authentication.mode"}, havingValue="none")
        static class EmbeddedGatewayCondition {
            EmbeddedGatewayCondition() {
            }
        }

        @ConditionalOnProperty(prefix="zeebe.gateway", value={"security.authentication.mode"}, havingValue="none")
        static class StandaloneGatewayCondition {
            StandaloneGatewayCondition() {
            }
        }
    }

    @Profile(value={"identity-auth"})
    @ConditionalOnManagementContext
    @EnableWebFluxSecurity
    @EnableReactiveMethodSecurity
    @ManagementContextConfiguration(value=ManagementContextType.ANY, proxyBeanMethods=false)
    public static final class ManagementSecurityConfiguration {
        @Bean
        public SecurityWebFilterChain managementSecurity(ServerHttpSecurity http) {
            return SecurityConfiguration.configureSecurity(http).authorizeExchange(spec -> spec.anyExchange().permitAll()).build();
        }
    }
}

