/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.document;

import io.camunda.document.Document;
import io.camunda.document.reference.DocumentReference;
import io.camunda.document.store.CamundaDocumentStore;
import io.camunda.zeebe.client.api.response.DocumentMetadata;
import java.io.InputStream;
import java.util.Base64;

public class CamundaDocument
implements Document {
    private final DocumentMetadata metadata;
    private final DocumentReference.CamundaDocumentReference reference;
    private final CamundaDocumentStore documentStore;

    public CamundaDocument(DocumentMetadata metadata, DocumentReference.CamundaDocumentReference reference, CamundaDocumentStore documentStore) {
        this.metadata = metadata;
        this.reference = reference;
        this.documentStore = documentStore;
    }

    @Override
    public DocumentMetadata metadata() {
        return this.metadata;
    }

    @Override
    public String asBase64() {
        return Base64.getEncoder().encodeToString(this.asByteArray());
    }

    @Override
    public InputStream asInputStream() {
        return this.documentStore.getDocumentContent(this.reference);
    }

    @Override
    public byte[] asByteArray() {
        try {
            return this.documentStore.getDocumentContent(this.reference).readAllBytes();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read document content: " + e.getMessage(), e);
        }
    }

    @Override
    public DocumentReference reference() {
        return this.reference;
    }
}

