/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.document.factory;

import io.camunda.document.CamundaDocument;
import io.camunda.document.Document;
import io.camunda.document.factory.DocumentFactory;
import io.camunda.document.reference.DocumentReference;
import io.camunda.document.store.CamundaDocumentStore;
import io.camunda.document.store.DocumentCreationRequest;

public class DocumentFactoryImpl
implements DocumentFactory {
    private final CamundaDocumentStore documentStore;

    public DocumentFactoryImpl(CamundaDocumentStore documentStore) {
        this.documentStore = documentStore;
    }

    @Override
    public Document resolve(DocumentReference reference) {
        if (reference == null) {
            return null;
        }
        if (reference instanceof DocumentReference.CamundaDocumentReference) {
            DocumentReference.CamundaDocumentReference camundaDocumentReference = (DocumentReference.CamundaDocumentReference)reference;
            return new CamundaDocument(camundaDocumentReference.metadata(), camundaDocumentReference, this.documentStore);
        }
        if (reference instanceof DocumentReference.ExternalDocumentReference) {
            DocumentReference.ExternalDocumentReference ignored = (DocumentReference.ExternalDocumentReference)reference;
            throw new IllegalArgumentException("External document references are not yet supported: " + String.valueOf(reference.getClass()));
        }
        throw new IllegalArgumentException("Unknown document reference type: " + String.valueOf(reference.getClass()));
    }

    @Override
    public Document create(DocumentCreationRequest request) {
        DocumentReference.CamundaDocumentReference reference = this.documentStore.createDocument(request);
        return this.resolve(reference);
    }
}

