/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.document.store;

import io.camunda.document.reference.CamundaDocumentReferenceImpl;
import io.camunda.document.reference.DocumentReference;
import io.camunda.document.store.CamundaDocumentStore;
import io.camunda.document.store.DocumentCreationRequest;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.command.CreateDocumentCommandStep1;
import io.camunda.zeebe.client.api.response.DocumentReferenceResponse;
import java.io.InputStream;

public class CamundaDocumentStoreImpl
implements CamundaDocumentStore {
    private final ZeebeClient zeebeClient;

    public CamundaDocumentStoreImpl(ZeebeClient zeebeClient) {
        this.zeebeClient = zeebeClient;
    }

    @Override
    public DocumentReference.CamundaDocumentReference createDocument(DocumentCreationRequest request) {
        CreateDocumentCommandStep1.CreateDocumentCommandStep2 command = this.zeebeClient.newCreateDocumentCommand().content(request.content());
        if (request.contentType() != null) {
            command.contentType(request.contentType());
        }
        if (request.fileName() != null) {
            command.fileName(request.fileName());
        }
        if (request.timeToLive() != null) {
            command.timeToLive(request.timeToLive());
        }
        if (request.customProperties() != null) {
            command.customMetadata(request.customProperties());
        }
        DocumentReferenceResponse response = (DocumentReferenceResponse)command.send().join();
        return new CamundaDocumentReferenceImpl(response);
    }

    @Override
    public InputStream getDocumentContent(DocumentReference.CamundaDocumentReference reference) {
        return (InputStream)this.zeebeClient.newDocumentContentGetRequest((DocumentReferenceResponse)reference).storeId(reference.storeId()).send().join();
    }

    @Override
    public void deleteDocument(DocumentReference.CamundaDocumentReference reference) {
        this.zeebeClient.newDeleteDocumentCommand(reference.documentId()).storeId(reference.storeId()).send().join();
    }
}

