/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.document.store;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.Duration;
import java.util.Map;

public record DocumentCreationRequest(InputStream content, String documentId, String storeId, String contentType, String fileName, Duration timeToLive, String processDefinitionId, Long processInstanceKey, Map<String, Object> customProperties) {
    public static BuilderFinalStep from(InputStream content) {
        return new BuilderFinalStep(content);
    }

    public static BuilderFinalStep from(byte[] content) {
        return new BuilderFinalStep(new ByteArrayInputStream(content));
    }

    public static class BuilderFinalStep {
        private final InputStream content;
        private String documentId;
        private String storeId;
        private String contentType;
        private String fileName;
        private Duration timeToLive;
        private String processDefinitionId;
        private Long processInstanceKey;
        private Map<String, Object> customProperties;

        public BuilderFinalStep(InputStream content) {
            this.content = content;
        }

        public BuilderFinalStep documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public BuilderFinalStep storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public BuilderFinalStep contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public BuilderFinalStep fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public BuilderFinalStep timeToLive(Duration timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        public BuilderFinalStep processDefinitionId(String processDefinitionId) {
            this.processDefinitionId = processDefinitionId;
            return this;
        }

        public BuilderFinalStep processInstanceKey(Long processInstanceKey) {
            this.processInstanceKey = processInstanceKey;
            return this;
        }

        public BuilderFinalStep customProperties(Map<String, Object> customProperties) {
            this.customProperties = customProperties;
            return this;
        }

        public DocumentCreationRequest build() {
            return new DocumentCreationRequest(this.content, this.documentId, this.storeId, this.contentType, this.fileName, this.timeToLive, this.processDefinitionId, this.processInstanceKey, this.customProperties);
        }
    }
}

