/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.document.store;

import io.camunda.document.reference.CamundaDocumentReferenceImpl;
import io.camunda.document.reference.DocumentReference;
import io.camunda.document.store.CamundaDocumentStore;
import io.camunda.document.store.DocumentCreationRequest;
import io.camunda.zeebe.client.api.response.DocumentMetadata;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;

public class InMemoryDocumentStore
implements CamundaDocumentStore {
    private static final Logger LOGGER = Logger.getLogger(InMemoryDocumentStore.class.getName());
    public static final String STORE_ID = "in-memory";
    public static InMemoryDocumentStore INSTANCE = new InMemoryDocumentStore();
    private final Map<String, byte[]> documents = new HashMap<String, byte[]>();

    private InMemoryDocumentStore() {
    }

    @Override
    public DocumentReference.CamundaDocumentReference createDocument(final DocumentCreationRequest request) {
        byte[] content;
        this.logWarning();
        final String id = request.documentId() != null ? request.documentId() : UUID.randomUUID().toString();
        DocumentMetadata metadata = new DocumentMetadata(){

            public String getContentType() {
                return request.contentType();
            }

            public OffsetDateTime getExpiresAt() {
                return null;
            }

            public Long getSize() {
                return InMemoryDocumentStore.this.documents.get(id).length;
            }

            public String getFileName() {
                return request.fileName();
            }

            public String getProcessDefinitionId() {
                return request.processDefinitionId();
            }

            public Long getProcessInstanceKey() {
                return request.processInstanceKey();
            }

            public Map<String, Object> getCustomProperties() {
                return request.customProperties();
            }
        };
        try (InputStream contentStream = request.content();){
            content = contentStream.readAllBytes();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read document content", e);
        }
        this.documents.put(id, content);
        return new CamundaDocumentReferenceImpl(STORE_ID, id, String.valueOf(content.length), metadata);
    }

    @Override
    public InputStream getDocumentContent(DocumentReference.CamundaDocumentReference reference) {
        this.logWarning();
        if (reference.getContentHash() == null || reference.getContentHash().isEmpty()) {
            throw new RuntimeException("Content hash is missing: " + reference.documentId());
        }
        String hash = reference.getContentHash();
        byte[] content = this.documents.get(reference.documentId());
        if (content == null) {
            throw new RuntimeException("Document not found: " + reference.documentId());
        }
        if (!hash.equals(String.valueOf(content.length))) {
            throw new RuntimeException("Content hash mismatch: " + reference.documentId());
        }
        return new ByteArrayInputStream(content);
    }

    @Override
    public void deleteDocument(DocumentReference.CamundaDocumentReference reference) {
        this.logWarning();
        this.documents.remove(reference.documentId());
    }

    public void clear() {
        this.documents.clear();
    }

    public Map<String, byte[]> getDocuments() {
        return this.documents;
    }

    public void logWarning() {
        LOGGER.warning("In-memory document store is used. This store is not suitable for production use.");
    }
}

