/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.feel;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import io.camunda.connector.feel.FeelConnectorFunctionProvider;
import io.camunda.connector.feel.FeelEngineWrapperException;
import java.util.HashMap;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.camunda.feel.FeelEngine;
import org.camunda.feel.context.FunctionProvider;
import org.camunda.feel.impl.JavaValueMapper;
import org.camunda.feel.valuemapper.CustomValueMapper;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.jdk.javaapi.CollectionConverters;
import scala.util.Either;

public class FeelEngineWrapper {
    static final String RESPONSE_MAP_KEY = "response";
    static final String ERROR_CONTEXT_IS_NULL = "Context is null";
    static final TypeReference<java.util.Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<java.util.Map<String, Object>>(){};
    private final FeelEngine feelEngine;
    private final ObjectMapper objectMapper;

    public FeelEngineWrapper() {
        this.feelEngine = new FeelEngine.Builder().customValueMapper((CustomValueMapper)new JavaValueMapper()).functionProvider((FunctionProvider)new FeelConnectorFunctionProvider()).build();
        this.objectMapper = new ObjectMapper().registerModule((Module)DefaultScalaModule$.MODULE$).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    }

    public FeelEngineWrapper(FeelEngine feelEngine, ObjectMapper objectMapper) {
        this.feelEngine = feelEngine;
        this.objectMapper = objectMapper;
    }

    private static String trimExpression(String expression) {
        String feelExpression = expression.trim();
        if (feelExpression.startsWith("=")) {
            feelExpression = feelExpression.substring(1);
        }
        return feelExpression.trim();
    }

    private static scala.collection.immutable.Map<String, Object> toScalaMap(java.util.Map<String, Object> responseMap) {
        HashMap<String, Object> context = new HashMap<String, Object>(responseMap);
        context.put(RESPONSE_MAP_KEY, responseMap);
        return scala.collection.immutable.Map.from((IterableOnce)CollectionConverters.asScala(context));
    }

    private java.util.Map<String, Object> ensureVariablesMap(Object variables) {
        try {
            Objects.requireNonNull(variables, ERROR_CONTEXT_IS_NULL);
            return (java.util.Map)this.objectMapper.convertValue(variables, MAP_TYPE_REFERENCE);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(String.format("Unable to parse '%s' as context", variables), ex);
        }
    }

    private <T> T sanitizeScalaOutput(T output) {
        if (output instanceof Map) {
            Map scalaMap = (Map)output;
            return (T)CollectionConverters.asJava((Map)scalaMap).entrySet().stream().collect(HashMap::new, (m, v) -> m.put(v.getKey(), this.sanitizeScalaOutput(v.getValue())), HashMap::putAll);
        }
        if (output instanceof Iterable) {
            Iterable scalaIterable = (Iterable)output;
            return (T)StreamSupport.stream(CollectionConverters.asJava((Iterable)scalaIterable).spliterator(), false).map(this::sanitizeScalaOutput).collect(Collectors.toList());
        }
        return output;
    }

    public <T> T evaluate(String expression, Object variables) {
        try {
            return (T)this.evaluateInternal(expression, variables);
        }
        catch (Exception e) {
            throw new FeelEngineWrapperException(e.getMessage(), expression, variables, e);
        }
    }

    public <T> T evaluate(String expression, Object variables, Class<T> clazz) {
        T result = this.evaluate(expression, variables);
        return (T)this.sanitizeScalaOutput(this.objectMapper.convertValue(result, clazz));
    }

    public <T> T evaluate(String expression, Object variables, JavaType clazz) {
        T result = this.evaluate(expression, variables);
        return (T)this.sanitizeScalaOutput(this.objectMapper.convertValue(result, clazz));
    }

    public String evaluateToJson(String expression, Object variables) {
        try {
            return this.resultToJson(this.evaluateInternal(expression, variables));
        }
        catch (Exception e) {
            throw new FeelEngineWrapperException(e.getMessage(), expression, variables, e);
        }
    }

    private Object evaluateInternal(String expression, Object variables) {
        java.util.Map<String, Object> variablesAsMap = this.ensureVariablesMap(variables);
        scala.collection.immutable.Map<String, Object> variablesAsMapAsScalaMap = FeelEngineWrapper.toScalaMap(variablesAsMap);
        Either result = this.feelEngine.evalExpression(FeelEngineWrapper.trimExpression(expression), variablesAsMapAsScalaMap);
        if (result.isRight()) {
            return result.right().get();
        }
        throw new RuntimeException(((FeelEngine.Failure)result.left().get()).message());
    }

    private String resultToJson(Object result) {
        try {
            return this.objectMapper.writeValueAsString(result);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("The output expression result cannot be parsed as JSON: " + result, e);
        }
    }
}

