/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.feel;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import io.camunda.connector.feel.FeelEngineWrapperException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.camunda.feel.FeelEngine;
import org.camunda.feel.impl.JavaValueMapper;
import org.camunda.feel.impl.SpiServiceLoader;
import org.camunda.feel.valuemapper.CustomValueMapper;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.jdk.javaapi.CollectionConverters;
import scala.util.Either;

public class FeelEngineWrapper {
    static final String ERROR_CONTEXT_IS_NULL = "Context is null";
    static final TypeReference<java.util.Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<java.util.Map<String, Object>>(){};
    private final FeelEngine feelEngine;
    private final ObjectMapper objectMapper;

    public FeelEngineWrapper() {
        this(new FeelEngine.Builder().customValueMapper((CustomValueMapper)new JavaValueMapper()).functionProvider(SpiServiceLoader.loadFunctionProvider()).build(), new ObjectMapper().registerModule((Module)DefaultScalaModule$.MODULE$).registerModule((Module)new JavaTimeModule()).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS));
    }

    public FeelEngineWrapper(FeelEngine feelEngine, ObjectMapper objectMapper) {
        this.feelEngine = feelEngine;
        this.objectMapper = objectMapper;
    }

    private static String trimExpression(String expression) {
        String feelExpression = expression.trim();
        if (feelExpression.startsWith("=")) {
            feelExpression = feelExpression.substring(1);
        }
        return feelExpression.trim();
    }

    private static scala.collection.immutable.Map<String, Object> toScalaMap(java.util.Map<String, Object> responseMap) {
        HashMap<String, Object> context = new HashMap<String, Object>(responseMap);
        return scala.collection.immutable.Map.from((IterableOnce)CollectionConverters.asScala(context));
    }

    private java.util.Map<String, Object> mergeMapVariables(Object[] variables) {
        try {
            Objects.requireNonNull(variables, ERROR_CONTEXT_IS_NULL);
            HashMap<String, Object> variablesMap = new HashMap<String, Object>();
            for (Object o : variables) {
                Objects.requireNonNull(o, ERROR_CONTEXT_IS_NULL);
                this.tryConvertToMap(o).ifPresent(variablesMap::putAll);
            }
            return variablesMap;
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(String.format("Unable to parse '%s' as context", variables), ex);
        }
    }

    private Optional<java.util.Map<String, Object>> tryConvertToMap(Object o) {
        try {
            return Optional.of((java.util.Map)this.objectMapper.convertValue(o, MAP_TYPE_REFERENCE));
        }
        catch (IllegalArgumentException ex) {
            return Optional.empty();
        }
    }

    private <T> T sanitizeScalaOutput(T output) {
        if (output instanceof Map) {
            Map scalaMap = (Map)output;
            return (T)CollectionConverters.asJava((Map)scalaMap).entrySet().stream().collect(HashMap::new, (m, v) -> m.put(v.getKey(), this.sanitizeScalaOutput(v.getValue())), HashMap::putAll);
        }
        if (output instanceof Iterable) {
            Iterable scalaIterable = (Iterable)output;
            return (T)StreamSupport.stream(CollectionConverters.asJava((Iterable)scalaIterable).spliterator(), false).map(this::sanitizeScalaOutput).collect(Collectors.toList());
        }
        return output;
    }

    public <T> T evaluate(String expression, Object ... variables) {
        try {
            return (T)this.evaluateInternal(expression, variables);
        }
        catch (Exception e) {
            throw new FeelEngineWrapperException(e.getMessage(), expression, variables, e);
        }
    }

    public <T> T evaluate(String expression, Class<T> clazz, Object ... variables) {
        Function<JsonNode, Object> converter = jsonNode -> {
            try {
                return this.objectMapper.treeToValue((TreeNode)jsonNode, clazz);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        };
        JavaType type = this.objectMapper.getTypeFactory().constructType(clazz);
        return (T)this.evaluateAndConvert(expression, type, converter, variables);
    }

    public <T> T evaluate(String expression, JavaType clazz, Object ... variables) {
        Function<JsonNode, Object> converter = jsonNode -> {
            try {
                return this.objectMapper.treeToValue((TreeNode)jsonNode, clazz);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        };
        return (T)this.evaluateAndConvert(expression, clazz, converter, variables);
    }

    public <T> T evaluate(DeserializationContext ctx, String expression, JavaType clazz, Object ... variables) {
        Function<JsonNode, Object> converter = jsonNode -> {
            try {
                if (jsonNode == null || jsonNode.isNull()) {
                    return null;
                }
                return ctx.readTreeAsValue(jsonNode, clazz);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        return (T)this.evaluateAndConvert(expression, clazz, converter, variables);
    }

    private <T> T evaluateAndConvert(String expression, JavaType clazz, Function<JsonNode, T> converter, Object ... variables) {
        T result = this.evaluate(expression, variables);
        JsonNode jsonNode = (JsonNode)this.objectMapper.convertValue(result, JsonNode.class);
        try {
            if (clazz.getRawClass().equals(String.class) && jsonNode.isObject()) {
                return (T)this.objectMapper.writeValueAsString((Object)jsonNode);
            }
            return this.sanitizeScalaOutput(converter.apply(jsonNode));
        }
        catch (Exception e) {
            throw new FeelEngineWrapperException("Failed to convert FEEL evaluation result to the target type", expression, variables, e);
        }
    }

    public String evaluateToJson(String expression, Object ... variables) {
        try {
            return this.resultToJson(this.evaluateInternal(expression, variables));
        }
        catch (Exception e) {
            throw new FeelEngineWrapperException(e.getMessage(), expression, variables, e);
        }
    }

    private Object evaluateInternal(String expression, Object[] variables) {
        java.util.Map<String, Object> variablesAsMap = this.mergeMapVariables(variables);
        scala.collection.immutable.Map<String, Object> variablesAsMapAsScalaMap = FeelEngineWrapper.toScalaMap(variablesAsMap);
        Either result = this.feelEngine.evalExpression(FeelEngineWrapper.trimExpression(expression), variablesAsMapAsScalaMap);
        if (result.isRight()) {
            return result.right().get();
        }
        throw new RuntimeException(((FeelEngine.Failure)result.left().get()).message());
    }

    private String resultToJson(Object result) {
        try {
            return this.objectMapper.writeValueAsString(result);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("The output expression result cannot be parsed as JSON: " + String.valueOf(result), e);
        }
    }
}

