/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.http.base.auth;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.api.client.http.HttpHeaders;
import io.camunda.connector.feel.annotation.FEEL;
import io.camunda.connector.generator.java.annotation.TemplateDiscriminatorProperty;
import io.camunda.connector.generator.java.annotation.TemplateProperty;
import io.camunda.connector.generator.java.annotation.TemplateSubType;
import io.camunda.connector.http.base.auth.ApiKeyLocation;
import io.camunda.connector.http.base.auth.Authentication;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@TemplateDiscriminatorProperty(label="API key", group="authentication", name="type", description="Send API key in the header, or as parameter in the query parameters")
@TemplateSubType(id="apiKey", label="API key")
public record ApiKeyAuthentication(@FEEL @NotNull @TemplateProperty(group="authentication", type=TemplateProperty.PropertyType.Dropdown, defaultValue="headers", choices={@TemplateProperty.DropdownPropertyChoice(value="headers", label="Headers"), @TemplateProperty.DropdownPropertyChoice(value="query", label="Query parameters")}, description="Choose type: Send API key in header or as query parameter.") ApiKeyLocation apiKeyLocation, @FEEL @NotEmpty @TemplateProperty(group="authentication", label="API key name") String name, @FEEL @NotEmpty @TemplateProperty(group="authentication", label="API key value") String value) implements Authentication
{
    @TemplateProperty(ignore=true)
    public static final String TYPE = "apiKey";

    @Override
    public void setHeaders(HttpHeaders headers) {
        if (ApiKeyLocation.HEADERS == this.apiKeyLocation) {
            headers.set(this.name, (Object)this.value);
        }
    }

    public boolean isQueryLocationApiKeyAuthentication() {
        return ApiKeyLocation.QUERY == this.apiKeyLocation;
    }
}

