/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.http.base.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.UrlEncodedContent;
import io.camunda.connector.http.base.auth.OAuthAuthentication;
import io.camunda.connector.http.base.model.HttpCommonRequest;
import io.camunda.connector.http.base.model.HttpMethod;
import io.camunda.connector.http.base.utils.JsonHelper;
import io.camunda.connector.http.base.utils.Timeout;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;

public class AuthenticationService {
    private final ObjectMapper objectMapper;
    private final HttpRequestFactory requestFactory;

    public AuthenticationService(ObjectMapper objectMapper, HttpRequestFactory requestFactory) {
        this.objectMapper = objectMapper;
        this.requestFactory = requestFactory;
    }

    public String extractOAuthAccessToken(HttpResponse oauthResponse) throws IOException {
        return Optional.ofNullable(JsonHelper.getAsJsonElement(oauthResponse.parseAsString(), this.objectMapper)).map(jsonNode -> jsonNode.findValue("access_token").asText()).orElse(null);
    }

    public HttpRequest createOAuthRequest(HttpCommonRequest request) throws IOException {
        OAuthAuthentication authentication = (OAuthAuthentication)request.getAuthentication();
        GenericUrl genericUrl = new GenericUrl(authentication.oauthTokenEndpoint());
        Map<String, String> data = authentication.getDataForAuthRequestBody();
        UrlEncodedContent content = new UrlEncodedContent(data);
        HttpRequest httpRequest = this.requestFactory.buildRequest(HttpMethod.POST.name(), genericUrl, (HttpContent)content);
        httpRequest.setFollowRedirects(false);
        Timeout.copyTimeoutFrom(request, httpRequest);
        HttpHeaders headers = new HttpHeaders();
        if ("basicAuthHeader".equals(authentication.clientAuthentication())) {
            headers.setBasicAuthentication(authentication.clientId(), authentication.clientSecret());
        }
        headers.setContentType("application/x-www-form-urlencoded");
        httpRequest.setHeaders(headers);
        return httpRequest;
    }
}

