/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.http.base.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import io.camunda.connector.api.error.ConnectorException;
import io.camunda.connector.http.base.blocklist.DefaultHttpBlocklistManager;
import io.camunda.connector.http.base.blocklist.HttpBlockListManager;
import io.camunda.connector.http.base.model.ErrorResponse;
import io.camunda.connector.http.base.model.HttpCommonResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpInteractionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpInteractionService.class);
    private final ObjectMapper objectMapper;
    private final HttpBlockListManager httpBlocklistManager;

    public HttpInteractionService(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.httpBlocklistManager = new DefaultHttpBlocklistManager();
    }

    public HttpResponse executeHttpRequest(HttpRequest externalRequest) throws IOException {
        return this.executeHttpRequest(externalRequest, false);
    }

    public HttpResponse executeHttpRequest(HttpRequest externalRequest, boolean isProxyCall) throws IOException {
        try {
            this.httpBlocklistManager.validateUrlAgainstBlocklist(externalRequest.getUrl());
            return externalRequest.execute();
        }
        catch (HttpResponseException hrex) {
            String errorCode = String.valueOf(hrex.getStatusCode());
            String errorMessage = hrex.getMessage();
            if (isProxyCall && hrex.getContent() != null) {
                try {
                    ErrorResponse errorContent = (ErrorResponse)this.objectMapper.readValue(hrex.getContent(), ErrorResponse.class);
                    errorCode = errorContent.getErrorCode();
                    errorMessage = errorContent.getError();
                }
                catch (Exception e) {
                    LOGGER.warn("Error response cannot be parsed as JSON! Will use the plain message.");
                }
            }
            throw new ConnectorException(errorCode, errorMessage, (Throwable)hrex);
        }
    }

    public <T extends HttpCommonResult> T toHttpResponse(HttpResponse externalResponse, Class<T> resultClass) throws InstantiationException, IllegalAccessException {
        HttpCommonResult connectorResult = (HttpCommonResult)resultClass.newInstance();
        connectorResult.setStatus(externalResponse.getStatusCode());
        HashMap<String, Object> headers = new HashMap<String, Object>();
        externalResponse.getHeaders().forEach((k, v) -> {
            if (v instanceof List && ((List)v).size() == 1) {
                headers.put((String)k, ((List)v).get(0));
            } else {
                headers.put((String)k, v);
            }
        });
        connectorResult.setHeaders(headers);
        try (InputStream content = externalResponse.getContent();){
            String bodyString = null;
            if (content != null) {
                bodyString = new String(content.readAllBytes(), StandardCharsets.UTF_8);
            }
            if (bodyString != null) {
                if (HttpInteractionService.isJSONValid(bodyString)) {
                    Object body = this.objectMapper.readValue(bodyString, Object.class);
                    connectorResult.setBody(body);
                } else {
                    connectorResult.setBody(bodyString);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse external response: {}", (Object)externalResponse, (Object)e);
        }
        return (T)connectorResult;
    }

    protected static boolean isJSONValid(String jsonInString) {
        boolean bl;
        JsonReader reader = new JsonReader((Reader)new StringReader(jsonInString));
        try {
            JsonElement jsonElement = JsonParser.parseReader((JsonReader)reader);
            bl = jsonElement.isJsonObject() || jsonElement.isJsonArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonParseException | IOException e) {
                return false;
            }
        }
        reader.close();
        return bl;
    }
}

