/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.http.base.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.http.AbstractHttpContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import io.camunda.connector.api.error.ConnectorException;
import io.camunda.connector.api.json.ConnectorsObjectMapperSupplier;
import io.camunda.connector.http.base.model.HttpCommonRequest;
import io.camunda.connector.http.base.model.HttpMethod;
import io.camunda.connector.http.base.model.HttpRequestBuilder;
import io.camunda.connector.http.base.services.HttpRequestMapper;
import io.camunda.connector.http.base.services.ProxyOAuthHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpProxyService {
    private static final Logger LOG = LoggerFactory.getLogger(HttpProxyService.class);
    private static final ObjectMapper objectMapper = ConnectorsObjectMapperSupplier.getCopy();

    public static HttpRequest toRequestViaProxy(HttpRequestFactory requestFactory, HttpCommonRequest request, String proxyFunctionUrl) throws IOException {
        final String contentAsJson = objectMapper.writeValueAsString((Object)request);
        AbstractHttpContent content = new AbstractHttpContent("application/json; charset=UTF-8"){

            public void writeTo(OutputStream outputStream) throws IOException {
                outputStream.write(contentAsJson.getBytes(StandardCharsets.UTF_8));
            }
        };
        HttpRequest httpRequest = new HttpRequestBuilder().method(HttpMethod.POST).genericUrl(new GenericUrl(proxyFunctionUrl)).content((HttpContent)content).connectionTimeoutInSeconds(request.getConnectionTimeoutInSeconds()).readTimeoutInSeconds(request.getReadTimeoutInSeconds()).writeTimeoutInSeconds(request.getWriteTimeoutInSeconds()).followRedirects(false).headers(HttpRequestMapper.extractRequestHeaders(request)).build(requestFactory);
        try {
            ProxyOAuthHelper.addOauthHeaders(httpRequest, ProxyOAuthHelper.initializeCredentials(proxyFunctionUrl));
            return httpRequest;
        }
        catch (Exception e) {
            LOG.error("Failure during OAuth authentication attempt for HTTP proxy function", (Throwable)e);
            throw new ConnectorException("Failure during OAuth authentication attempt for HTTP proxy function");
        }
    }
}

