/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.http.base.services;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import io.camunda.connector.http.base.auth.ApiKeyAuthentication;
import io.camunda.connector.http.base.auth.Authentication;
import io.camunda.connector.http.base.auth.OAuthAuthentication;
import io.camunda.connector.http.base.model.HttpCommonRequest;
import io.camunda.connector.http.base.model.HttpMethod;
import io.camunda.connector.http.base.model.HttpRequestBuilder;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.http.entity.ContentType;

public class HttpRequestMapper {
    private HttpRequestMapper() {
    }

    public static HttpRequest toOAuthHttpRequest(HttpRequestFactory requestFactory, HttpCommonRequest request) throws IOException {
        OAuthAuthentication authentication = (OAuthAuthentication)request.getAuthentication();
        HttpHeaders headers = new HttpHeaders();
        if (authentication.clientAuthentication().equals("basicAuthHeader")) {
            headers.setBasicAuthentication(authentication.clientId(), authentication.clientSecret());
        }
        headers.setContentType("application/x-www-form-urlencoded");
        return new HttpRequestBuilder().method(HttpMethod.POST).genericUrl(new GenericUrl(authentication.oauthTokenEndpoint())).content((HttpContent)new UrlEncodedContent(authentication.getDataForAuthRequestBody())).headers(headers).connectionTimeoutInSeconds(request.getConnectionTimeoutInSeconds()).readTimeoutInSeconds(request.getReadTimeoutInSeconds()).writeTimeoutInSeconds(request.getWriteTimeoutInSeconds()).followRedirects(false).build(requestFactory);
    }

    public static HttpRequest toHttpRequest(HttpRequestFactory requestFactory, HttpCommonRequest request) throws IOException {
        return HttpRequestMapper.toHttpRequest(requestFactory, request, null);
    }

    public static HttpRequest toHttpRequest(HttpRequestFactory requestFactory, HttpCommonRequest request, String bearerToken) throws IOException {
        ApiKeyAuthentication authentication;
        Authentication authentication2;
        GenericUrl genericUrl = new GenericUrl(request.getUrl());
        HttpHeaders headers = HttpRequestMapper.createHeaders(request, bearerToken);
        if (request.hasQueryParameters()) {
            genericUrl.putAll(request.getQueryParameters());
        }
        if (request.hasAuthentication() && (authentication2 = request.getAuthentication()) instanceof ApiKeyAuthentication && (authentication = (ApiKeyAuthentication)authentication2).isQueryLocationApiKeyAuthentication()) {
            genericUrl.put(authentication.name(), (Object)authentication.value());
        }
        if (request.hasBody() && request.getBody() instanceof String) {
            String unescapeBody = StringEscapeUtils.unescapeJson((String)((String)request.getBody()));
            request.setBody(unescapeBody);
        }
        Object content = null;
        if (request.getMethod().supportsBody) {
            content = ContentType.APPLICATION_FORM_URLENCODED.getMimeType().equalsIgnoreCase(headers.getContentType()) ? new UrlEncodedContent(request.getBody()) : (request.hasBody() ? new JsonHttpContent((JsonFactory)new GsonFactory(), request.getBody()) : null);
        }
        return new HttpRequestBuilder().method(request.getMethod()).genericUrl(genericUrl).content((HttpContent)content).headers(headers).connectionTimeoutInSeconds(request.getConnectionTimeoutInSeconds()).readTimeoutInSeconds(request.getReadTimeoutInSeconds()).writeTimeoutInSeconds(request.getWriteTimeoutInSeconds()).followRedirects(false).build(requestFactory);
    }

    public static HttpHeaders createHeaders(HttpCommonRequest request, String bearerToken) {
        HttpHeaders httpHeaders = new HttpHeaders();
        if (request.getMethod().supportsBody) {
            httpHeaders.setContentType(ContentType.APPLICATION_JSON.getMimeType());
        }
        if (request.hasAuthentication()) {
            if (bearerToken != null && !bearerToken.isEmpty()) {
                httpHeaders.setAuthorization("Bearer " + bearerToken);
            }
            request.getAuthentication().setHeaders(httpHeaders);
        }
        httpHeaders.putAll((Map)HttpRequestMapper.extractRequestHeaders(request));
        return httpHeaders;
    }

    public static HttpHeaders extractRequestHeaders(HttpCommonRequest httpCommonRequest) {
        if (httpCommonRequest.hasHeaders()) {
            HttpHeaders httpHeaders = new HttpHeaders();
            httpCommonRequest.getHeaders().forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).set(arg_0, arg_1));
            return httpHeaders;
        }
        return new HttpHeaders();
    }
}

