/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.http.base.utils;

import com.google.api.client.http.HttpRequest;
import io.camunda.connector.http.base.model.HttpCommonRequest;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class Timeout {
    public static void copyTimeoutFrom(HttpCommonRequest request, HttpRequest httpRequest) {
        Timeout.copyTimeoutFrom(httpRequest, request.getConnectionTimeoutInSeconds(), request.getReadTimeoutInSeconds(), request.getWriteTimeoutInSeconds());
    }

    public static void copyTimeoutFrom(HttpRequest httpRequest, Integer connectionTimeoutInSeconds, Integer readTimeoutInSeconds, Integer writeTimeoutInSeconds) {
        Optional<Integer> connectionTimeoutInMillis = Timeout.toMillis(connectionTimeoutInSeconds);
        connectionTimeoutInMillis.ifPresent(arg_0 -> ((HttpRequest)httpRequest).setConnectTimeout(arg_0));
        Timeout.toMillis(readTimeoutInSeconds).ifPresent(arg_0 -> ((HttpRequest)httpRequest).setReadTimeout(arg_0));
        Timeout.toMillis(writeTimeoutInSeconds).ifPresent(arg_0 -> ((HttpRequest)httpRequest).setWriteTimeout(arg_0));
        if (writeTimeoutInSeconds == null && readTimeoutInSeconds == null) {
            connectionTimeoutInMillis.ifPresent(timeout -> {
                httpRequest.setReadTimeout(timeout.intValue());
                httpRequest.setWriteTimeout(timeout.intValue());
            });
        }
    }

    private static Optional<Integer> toMillis(Integer seconds) {
        return Optional.ofNullable(seconds).map(s -> Math.toIntExact(TimeUnit.SECONDS.toMillis(s.intValue())));
    }
}

