/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.inbound.lifecycle;

import io.camunda.connector.api.inbound.CorrelationResult;
import io.camunda.connector.feel.FeelEngineWrapper;
import io.camunda.connector.runtime.core.inbound.InboundConnectorDefinitionImpl;
import io.camunda.connector.runtime.core.inbound.correlation.InboundCorrelationHandler;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.spring.client.metrics.MetricsRecorder;

public class MeteredInboundCorrelationHandler
extends InboundCorrelationHandler {
    private final MetricsRecorder metricsRecorder;

    public MeteredInboundCorrelationHandler(ZeebeClient zeebeClient, FeelEngineWrapper feelEngine, MetricsRecorder metricsRecorder) {
        super(zeebeClient, feelEngine);
        this.metricsRecorder = metricsRecorder;
    }

    protected boolean isActivationConditionMet(InboundConnectorDefinitionImpl def, Object context) {
        boolean isConditionMet = super.isActivationConditionMet(def, context);
        if (!isConditionMet) {
            this.metricsRecorder.increase("camunda.connector.inbound.triggers", "activation-condition-failed", def.type());
        }
        return isConditionMet;
    }

    public CorrelationResult correlate(InboundConnectorDefinitionImpl definition, Object variables) {
        this.metricsRecorder.increase("camunda.connector.inbound.triggers", "triggered", definition.type());
        try {
            CorrelationResult result = super.correlate(definition, variables);
            this.metricsRecorder.increase("camunda.connector.inbound.triggers", "correlated", definition.type());
            return result;
        }
        catch (Exception e) {
            this.metricsRecorder.increase("camunda.connector.inbound.triggers", "correlation-failed", definition.type());
            throw e;
        }
    }
}

