/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.inbound.webhook.model;

import io.camunda.connector.api.inbound.webhook.WebhookProcessingPayload;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public class HttpServletRequestWebhookProcessingPayload
implements WebhookProcessingPayload {
    private final String requestURL;
    private final String method;
    private final Map<String, String> headers;
    private final Map<String, String> params;
    private final byte[] rawBody;

    public HttpServletRequestWebhookProcessingPayload(HttpServletRequest httpServletRequest, Map<String, String> params, Map<String, String> headers, byte[] bodyAsByteArray) {
        this.requestURL = httpServletRequest.getRequestURL().toString();
        this.method = httpServletRequest.getMethod();
        this.headers = headers;
        this.params = params;
        this.rawBody = bodyAsByteArray;
    }

    public String requestURL() {
        return this.requestURL;
    }

    public String method() {
        return this.method;
    }

    public Map<String, String> headers() {
        return Collections.unmodifiableMap(Optional.ofNullable(this.headers).orElse(Collections.emptyMap()));
    }

    public Map<String, String> params() {
        return Collections.unmodifiableMap(Optional.ofNullable(this.params).orElse(Collections.emptyMap()));
    }

    public byte[] rawBody() {
        return this.rawBody != null ? Arrays.copyOf(this.rawBody, this.rawBody.length) : null;
    }

    public String toString() {
        return "HttpServletRequestWebhookProcessingPayload{requestURL='" + this.requestURL + "', method='" + this.method + "', headers=" + String.valueOf(this.headers) + ", params=" + String.valueOf(this.params) + ", rawBody=" + Arrays.toString(this.rawBody) + "}";
    }
}

