/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.outbound.lifecycle;

import io.camunda.connector.api.annotation.OutboundConnector;
import io.camunda.connector.api.outbound.OutboundConnectorFunction;
import io.camunda.connector.runtime.core.config.ConnectorConfiguration;
import io.camunda.connector.runtime.core.config.OutboundConnectorConfiguration;
import io.camunda.connector.runtime.core.outbound.OutboundConnectorFactory;
import io.camunda.connector.runtime.outbound.lifecycle.OutboundConnectorManager;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.spring.client.annotation.processor.AbstractZeebeAnnotationProcessor;
import io.camunda.zeebe.spring.client.bean.BeanInfo;
import io.camunda.zeebe.spring.client.bean.ClassInfo;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutboundConnectorAnnotationProcessor
extends AbstractZeebeAnnotationProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OutboundConnectorManager outboundConnectorManager;
    private final OutboundConnectorFactory outboundConnectorFactory;

    public OutboundConnectorAnnotationProcessor(OutboundConnectorManager outboundConnectorManager, OutboundConnectorFactory outboundConnectorFactory) {
        this.outboundConnectorManager = outboundConnectorManager;
        this.outboundConnectorFactory = outboundConnectorFactory;
    }

    public boolean isApplicableFor(ClassInfo beanInfo) {
        return beanInfo.hasClassAnnotation(OutboundConnector.class);
    }

    public void configureFor(ClassInfo beanInfo) {
        beanInfo.getAnnotation(OutboundConnector.class).map(outboundConnector -> this.registerOutboundConnector((OutboundConnector)outboundConnector, (BeanInfo)beanInfo));
    }

    private OutboundConnectorConfiguration registerOutboundConnector(OutboundConnector outboundConnector, BeanInfo beanInfo) {
        OutboundConnectorConfiguration configuration = new OutboundConnectorConfiguration(outboundConnector.name(), outboundConnector.inputVariables(), outboundConnector.type(), beanInfo.getTargetClass(), () -> (OutboundConnectorFunction)beanInfo.getBean());
        LOGGER.info("Configuring outbound connector {} of bean '{}'", (Object)configuration, (Object)beanInfo.getBeanName());
        this.outboundConnectorFactory.registerConfiguration((ConnectorConfiguration)configuration);
        return configuration;
    }

    public void start(ZeebeClient client) {
        this.outboundConnectorManager.start(client);
    }

    public void stop(ZeebeClient client) {
        this.outboundConnectorManager.stop();
    }
}

