/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.inbound.executable;

import io.camunda.connector.api.inbound.Health;
import io.camunda.connector.api.inbound.ProcessElement;
import io.camunda.connector.runtime.core.config.InboundConnectorConfiguration;
import io.camunda.connector.runtime.core.inbound.InboundConnectorElement;
import io.camunda.connector.runtime.core.inbound.InboundConnectorFactory;
import io.camunda.connector.runtime.core.inbound.details.InboundConnectorDetails;
import io.camunda.connector.runtime.inbound.executable.ActiveExecutableQuery;
import io.camunda.connector.runtime.inbound.executable.ActiveExecutableResponse;
import io.camunda.connector.runtime.inbound.executable.BatchExecutableProcessor;
import io.camunda.connector.runtime.inbound.executable.InboundExecutableEvent;
import io.camunda.connector.runtime.inbound.executable.InboundExecutableRegistry;
import io.camunda.connector.runtime.inbound.executable.RegisteredExecutable;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;

public class InboundExecutableRegistryImpl
implements InboundExecutableRegistry {
    private final BlockingQueue<InboundExecutableEvent> eventQueue;
    private final ExecutorService executorService;
    private final BatchExecutableProcessor batchExecutableProcessor;
    private final Map<ProcessElement, UUID> executablesByElement = new ConcurrentHashMap<ProcessElement, UUID>();
    final Map<UUID, RegisteredExecutable> executables = new HashMap<UUID, RegisteredExecutable>();
    private static final Logger LOG = LoggerFactory.getLogger(InboundExecutableRegistryImpl.class);
    private final Map<String, List<String>> deduplicationScopesByType;
    private final BiConsumer<Throwable, UUID> cancellationCallback = (throwable, id) -> {
        LOG.warn("Inbound connector executable has requested its cancellation", throwable);
        RegisteredExecutable toCancel = this.executables.get(id);
        if (toCancel == null) {
            LOG.error("Inbound connector executable not found for the given ID: {}", id);
            return;
        }
        if (toCancel instanceof RegisteredExecutable.Activated) {
            RegisteredExecutable.Activated activated = (RegisteredExecutable.Activated)toCancel;
            activated.context().reportHealth(Health.down((Throwable)throwable));
            try {
                activated.executable().deactivate();
            }
            catch (Exception e) {
                LOG.error("Failed to deactivate connector", (Throwable)e);
            }
        } else {
            LOG.error("Attempted to cancel an inbound connector executable that is not in the active state: {}", id);
        }
    };

    public InboundExecutableRegistryImpl(InboundConnectorFactory connectorFactory, BatchExecutableProcessor batchExecutableProcessor) {
        this.batchExecutableProcessor = batchExecutableProcessor;
        this.executorService = Executors.newSingleThreadExecutor();
        this.eventQueue = new LinkedBlockingQueue<InboundExecutableEvent>();
        this.deduplicationScopesByType = connectorFactory.getConfigurations().stream().collect(Collectors.toMap(InboundConnectorConfiguration::type, InboundConnectorConfiguration::deduplicationProperties));
        this.startEventProcessing();
    }

    void startEventProcessing() {
        this.executorService.submit(() -> {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    this.handleEvent(this.eventQueue.take());
                }
            }
            catch (InterruptedException e) {
                LOG.error("Event processing thread interrupted", (Throwable)e);
            }
        });
    }

    @Override
    public void publishEvent(InboundExecutableEvent event) {
        this.eventQueue.add(event);
        LOG.debug("Event added to the queue: {}", (Object)event);
    }

    void handleEvent(InboundExecutableEvent event) {
        InboundExecutableEvent inboundExecutableEvent = event;
        Objects.requireNonNull(inboundExecutableEvent);
        InboundExecutableEvent inboundExecutableEvent2 = inboundExecutableEvent;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{InboundExecutableEvent.Activated.class, InboundExecutableEvent.Deactivated.class}, (Object)inboundExecutableEvent2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                InboundExecutableEvent.Activated activated = (InboundExecutableEvent.Activated)inboundExecutableEvent2;
                this.handleActivated(activated);
                break;
            }
            case 1: {
                InboundExecutableEvent.Deactivated deactivated = (InboundExecutableEvent.Deactivated)inboundExecutableEvent2;
                this.handleDeactivated(deactivated);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleActivated(InboundExecutableEvent.Activated activated) {
        LOG.debug("Handling activated event for process definition {} (tenant {})", (Object)activated.processDefinitionKey(), (Object)activated.tenantId());
        List<InboundConnectorElement> elements = activated.elements();
        if (elements.isEmpty()) {
            LOG.debug("No elements provided for activation");
            return;
        }
        String processId = activated.tenantId() + activated.processDefinitionKey();
        String string = processId.intern();
        synchronized (string) {
            try {
                Map<UUID, InboundConnectorDetails> groupedConnectors = this.groupElements(elements).stream().collect(Collectors.toMap(connector -> UUID.randomUUID(), connector -> connector));
                groupedConnectors.forEach((id, connectorDetails) -> connectorDetails.connectorElements().forEach(element -> this.executablesByElement.put(element.element(), (UUID)id)));
                Map<UUID, RegisteredExecutable> activationResult = this.batchExecutableProcessor.activateBatch(groupedConnectors, this.cancellationCallback);
                this.executables.putAll(activationResult);
            }
            catch (Exception e) {
                LOG.error("Failed to activate connectors", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDeactivated(InboundExecutableEvent.Deactivated deactivated) {
        LOG.debug("Handling deactivated event for process {} (tenant {}) ", (Object)deactivated.processDefinitionKey(), (Object)deactivated.tenantId());
        String processId = deactivated.tenantId() + deactivated.processDefinitionKey();
        String string = processId.intern();
        synchronized (string) {
            try {
                List<RegisteredExecutable> executablesToDeactivate = this.executablesByElement.keySet().stream().filter(element -> element.tenantId().equals(deactivated.tenantId()) && element.processDefinitionKey() == deactivated.processDefinitionKey()).map(this.executablesByElement::remove).map(this.executables::remove).toList();
                if (executablesToDeactivate.isEmpty()) {
                    LOG.debug("No executables found for deactivation");
                    return;
                }
                this.batchExecutableProcessor.deactivateBatch(executablesToDeactivate);
            }
            catch (Exception e) {
                LOG.error("Failed to deactivate connectors", (Throwable)e);
            }
        }
    }

    @Override
    public List<ActiveExecutableResponse> query(ActiveExecutableQuery query) {
        return this.executables.entrySet().stream().filter(entry -> this.matchesQuery((RegisteredExecutable)entry.getValue(), query)).map(entry -> this.mapToResponse((UUID)entry.getKey(), (RegisteredExecutable)entry.getValue())).toList();
    }

    private List<InboundConnectorDetails> groupElements(List<InboundConnectorElement> elements) {
        HashMap<String, List> groupedElements = new HashMap<String, List>();
        for (InboundConnectorElement element : elements) {
            try {
                List deduplicationProperties = Optional.ofNullable(this.deduplicationScopesByType.get(element.type())).orElse(List.of());
                String deduplicationId = element.deduplicationId(deduplicationProperties);
                groupedElements.computeIfAbsent(deduplicationId, k -> new ArrayList()).add(element);
            }
            catch (Exception e) {
                LOG.error("Failed to get deduplication ID for element {} in process {}", new Object[]{element.element().elementId(), element.element().bpmnProcessId(), e});
            }
        }
        return groupedElements.entrySet().stream().map(entry -> InboundConnectorDetails.of((String)((String)entry.getKey()), (List)((List)entry.getValue()))).toList();
    }

    private boolean matchesQuery(RegisteredExecutable executable, ActiveExecutableQuery query) {
        RegisteredExecutable registeredExecutable = executable;
        Objects.requireNonNull(registeredExecutable);
        RegisteredExecutable registeredExecutable2 = registeredExecutable;
        int n = 0;
        List<ProcessElement> elements = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RegisteredExecutable.Activated.class, RegisteredExecutable.FailedToActivate.class, RegisteredExecutable.ConnectorNotRegistered.class, RegisteredExecutable.InvalidDefinition.class}, (Object)registeredExecutable2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                RegisteredExecutable.Activated activated = (RegisteredExecutable.Activated)registeredExecutable2;
                yield activated.context().connectorElements().stream().map(InboundConnectorElement::element).toList();
            }
            case 1 -> {
                RegisteredExecutable.FailedToActivate failed = (RegisteredExecutable.FailedToActivate)registeredExecutable2;
                yield failed.data().connectorElements().stream().map(InboundConnectorElement::element).toList();
            }
            case 2 -> {
                RegisteredExecutable.ConnectorNotRegistered notRegistered = (RegisteredExecutable.ConnectorNotRegistered)registeredExecutable2;
                yield notRegistered.data().connectorElements().stream().map(InboundConnectorElement::element).toList();
            }
            case 3 -> {
                RegisteredExecutable.InvalidDefinition invalid = (RegisteredExecutable.InvalidDefinition)registeredExecutable2;
                yield invalid.data().connectorElements().stream().map(InboundConnectorElement::element).toList();
            }
        };
        RegisteredExecutable registeredExecutable3 = executable;
        Objects.requireNonNull(registeredExecutable3);
        RegisteredExecutable registeredExecutable4 = registeredExecutable3;
        int n2 = 0;
        String type = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RegisteredExecutable.Activated.class, RegisteredExecutable.FailedToActivate.class, RegisteredExecutable.ConnectorNotRegistered.class, RegisteredExecutable.InvalidDefinition.class}, (Object)registeredExecutable4, n2)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                RegisteredExecutable.Activated activated = (RegisteredExecutable.Activated)registeredExecutable4;
                yield activated.context().getDefinition().type();
            }
            case 1 -> {
                RegisteredExecutable.FailedToActivate failed = (RegisteredExecutable.FailedToActivate)registeredExecutable4;
                yield ((InboundConnectorElement)failed.data().connectorElements().getFirst()).type();
            }
            case 2 -> {
                RegisteredExecutable.ConnectorNotRegistered notRegistered = (RegisteredExecutable.ConnectorNotRegistered)registeredExecutable4;
                yield notRegistered.data().type();
            }
            case 3 -> {
                RegisteredExecutable.InvalidDefinition invalid = (RegisteredExecutable.InvalidDefinition)registeredExecutable4;
                yield ((InboundConnectorElement)invalid.data().connectorElements().getFirst()).type();
            }
        };
        return elements.stream().anyMatch(element -> this.processIdMatches((ProcessElement)element, query) && this.typeMatches(type, query) && this.tenantIdMatches((ProcessElement)element, query) && this.elementIdMatches(element.elementId(), query));
    }

    private boolean processIdMatches(ProcessElement element, ActiveExecutableQuery query) {
        return query.bpmnProcessId() == null || query.bpmnProcessId().equals(element.bpmnProcessId());
    }

    private boolean tenantIdMatches(ProcessElement element, ActiveExecutableQuery query) {
        return query.tenantId() == null || query.tenantId().equals(element.tenantId());
    }

    private boolean typeMatches(String type, ActiveExecutableQuery query) {
        return query.type() == null || type == null || query.type().equals(type);
    }

    private boolean elementIdMatches(String elementId, ActiveExecutableQuery query) {
        return query.elementId() == null || query.elementId().equals(elementId);
    }

    private ActiveExecutableResponse mapToResponse(UUID id, RegisteredExecutable connector) {
        RegisteredExecutable registeredExecutable = connector;
        Objects.requireNonNull(registeredExecutable);
        RegisteredExecutable registeredExecutable2 = registeredExecutable;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RegisteredExecutable.Activated.class, RegisteredExecutable.FailedToActivate.class, RegisteredExecutable.ConnectorNotRegistered.class, RegisteredExecutable.InvalidDefinition.class}, (Object)registeredExecutable2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                RegisteredExecutable.Activated activated = (RegisteredExecutable.Activated)registeredExecutable2;
                yield new ActiveExecutableResponse(id, activated.executable().getClass(), activated.context().connectorElements(), activated.context().getHealth(), activated.context().getLogs());
            }
            case 1 -> {
                RegisteredExecutable.FailedToActivate failed = (RegisteredExecutable.FailedToActivate)registeredExecutable2;
                yield new ActiveExecutableResponse(id, null, failed.data().connectorElements(), Health.down((Health.Error)new Health.Error("Activation failure", failed.reason())), List.of());
            }
            case 2 -> {
                RegisteredExecutable.ConnectorNotRegistered notRegistered = (RegisteredExecutable.ConnectorNotRegistered)registeredExecutable2;
                yield new ActiveExecutableResponse(id, null, notRegistered.data().connectorElements(), Health.down((Health.Error)new Health.Error("Activation failure", "Connector " + notRegistered.data().type() + " not registered")), List.of());
            }
            case 3 -> {
                RegisteredExecutable.InvalidDefinition invalid = (RegisteredExecutable.InvalidDefinition)registeredExecutable2;
                yield new ActiveExecutableResponse(id, null, invalid.data().connectorElements(), Health.down((Health.Error)new Health.Error("Activation failure", "Invalid connector definition: " + invalid.reason())), List.of());
            }
        };
    }

    @Scheduled(fixedRate=3600000L)
    public void logStatusReport() {
        LOG.info("Inbound connector status report - {} executables active", (Object)this.executables.size());
        this.executables.values().stream().collect(Collectors.groupingBy(activeExecutable -> {
            RegisteredExecutable registeredExecutable = activeExecutable;
            Objects.requireNonNull(registeredExecutable);
            RegisteredExecutable selector0$temp = registeredExecutable;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RegisteredExecutable.Activated.class, RegisteredExecutable.FailedToActivate.class, RegisteredExecutable.ConnectorNotRegistered.class, RegisteredExecutable.InvalidDefinition.class}, (Object)selector0$temp, index$1)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    RegisteredExecutable.Activated activated = (RegisteredExecutable.Activated)selector0$temp;
                    yield activated.context().getDefinition().type();
                }
                case 1 -> {
                    RegisteredExecutable.FailedToActivate failed = (RegisteredExecutable.FailedToActivate)selector0$temp;
                    yield ((InboundConnectorElement)failed.data().connectorElements().getFirst()).type();
                }
                case 2 -> {
                    RegisteredExecutable.ConnectorNotRegistered notRegistered = (RegisteredExecutable.ConnectorNotRegistered)selector0$temp;
                    yield notRegistered.data().type();
                }
                case 3 -> {
                    RegisteredExecutable.InvalidDefinition invalid = (RegisteredExecutable.InvalidDefinition)selector0$temp;
                    yield invalid.data().type();
                }
            };
        }, Collectors.toList())).forEach((type, list) -> {
            long successfullyActivatedCount = list.stream().filter(RegisteredExecutable.Activated.class::isInstance).count();
            LOG.info(". '{}' - {}, of which {} successfully activated", new Object[]{type, list.size(), successfullyActivatedCount});
            Map<String, Long> groupedByTenant = list.stream().collect(Collectors.groupingBy(activeExecutable -> {
                RegisteredExecutable registeredExecutable = activeExecutable;
                Objects.requireNonNull(registeredExecutable);
                RegisteredExecutable selector0$temp = registeredExecutable;
                int index$1 = 0;
                return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RegisteredExecutable.Activated.class, RegisteredExecutable.FailedToActivate.class, RegisteredExecutable.ConnectorNotRegistered.class, RegisteredExecutable.InvalidDefinition.class}, (Object)selector0$temp, index$1)) {
                    default -> throw new MatchException(null, null);
                    case 0 -> {
                        RegisteredExecutable.Activated activated = (RegisteredExecutable.Activated)selector0$temp;
                        yield activated.context().getDefinition().tenantId();
                    }
                    case 1 -> {
                        RegisteredExecutable.FailedToActivate failed = (RegisteredExecutable.FailedToActivate)selector0$temp;
                        yield failed.data().tenantId();
                    }
                    case 2 -> {
                        RegisteredExecutable.ConnectorNotRegistered notRegistered = (RegisteredExecutable.ConnectorNotRegistered)selector0$temp;
                        yield notRegistered.data().tenantId();
                    }
                    case 3 -> {
                        RegisteredExecutable.InvalidDefinition invalid = (RegisteredExecutable.InvalidDefinition)selector0$temp;
                        yield invalid.data().tenantId();
                    }
                };
            }, Collectors.counting()));
            groupedByTenant.forEach((tenant, count) -> LOG.info(". . {} for tenant {}", count, tenant));
        });
    }
}

