/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.inbound.importer;

import io.camunda.connector.runtime.inbound.importer.ProcessDefinitionImporter;
import io.camunda.operate.CamundaOperateClient;
import io.camunda.operate.exception.OperateException;
import io.camunda.operate.model.ProcessDefinition;
import io.camunda.operate.model.SearchResult;
import io.camunda.operate.search.SearchQuery;
import io.camunda.operate.search.Sort;
import io.camunda.operate.search.SortOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ProcessDefinitionSearch {
    private static final int PAGE_SIZE = 50;
    private static final Logger LOG = LoggerFactory.getLogger(ProcessDefinitionImporter.class);
    private final CamundaOperateClient camundaOperateClient;

    public ProcessDefinitionSearch(CamundaOperateClient camundaOperateClient) {
        this.camundaOperateClient = camundaOperateClient;
    }

    public List<ProcessDefinition> query() {
        SearchResult processDefinitionResult;
        LOG.trace("Query process deployments...");
        ArrayList<ProcessDefinition> processDefinitions = new ArrayList<ProcessDefinition>();
        LOG.trace("Running paginated query");
        List paginationIndex = null;
        HashSet encounteredBpmnProcessIds = new HashSet();
        do {
            try {
                SearchQuery processDefinitionQuery = new SearchQuery.Builder().searchAfter(paginationIndex).sort(new Sort("key", SortOrder.DESC)).size(Integer.valueOf(50)).build();
                processDefinitionResult = this.camundaOperateClient.searchProcessDefinitionResults(processDefinitionQuery);
            }
            catch (OperateException e) {
                throw new RuntimeException(e);
            }
            List newPaginationIdx = processDefinitionResult.getSortValues();
            if (!CollectionUtils.isEmpty((Collection)newPaginationIdx)) {
                paginationIndex = newPaginationIdx;
            }
            List<ProcessDefinition> items = Optional.ofNullable(processDefinitionResult.getItems()).orElse(List.of()).stream().filter(definition -> !encounteredBpmnProcessIds.contains(definition.getBpmnProcessId())).peek(definition -> encounteredBpmnProcessIds.add(definition.getBpmnProcessId())).toList();
            processDefinitions.addAll(items);
        } while (processDefinitionResult.getItems() != null && !processDefinitionResult.getItems().isEmpty());
        return processDefinitions;
    }
}

